/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.io;

import com.valeras.color_chart.ColorChartEntry;
import com.valeras.color_chart.ColorLookupTable;
import com.valeras.color_chart.io.CLUEFactory;
import com.valeras.color_chart.io.CLUEParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;

public class CLUTReader {
    private final CLUEParser parser;
    private final CLUEFactory factory;

    public CLUTReader(CLUEParser parser, CLUEFactory factory) {
        this.parser = parser;
        this.factory = factory;
    }

    public Collection<ColorChartEntry> read(InputStream stream, ColorLookupTable clut) throws IOException, ParseException {
        String l_text;
        ArrayList<ColorChartEntry> l_entries = new ArrayList<ColorChartEntry>();
        BufferedReader l_br = new BufferedReader(new InputStreamReader(stream));
        while ((l_text = l_br.readLine()) != null) {
            Object l_entry = this.factory.create();
            this.parser.parse(l_text, l_entry);
            if (l_entry == null) continue;
            clut.put(((ColorChartEntry)l_entry).getColor(), l_entry);
            l_entries.add((ColorChartEntry)l_entry);
        }
        return l_entries;
    }
}

