/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart.io;

import com.valeras.color_chart.ColorChartEntry;
import com.valeras.color_chart.io.CLUEParser;
import com.valeras.color_chart.io.format.ColorRGBHexFormat;
import com.valeras.color_chart.io.format.ColorRGBTupleFormat;
import com.valeras.color_chart.io.format.FloatArrayFormat;
import com.valeras.color_chart.io.format.StringFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CLUECSVParser
implements CLUEParser {
    public static final String FORMAT_STRING = "format.string";
    public static final String FORMAT_COLOR_RGB_HEX = "format.rgb_hex";
    public static final String FORMAT_COLOR_RGB_TUPLE = "format.rgb_tuple";
    public static final String FORMAT_FLOAT_ARRAY = "format.float_array";
    protected static final String DEFAULT_DELIMITER = ";";
    private static final String ERR_NO_FORMAT = "Appropriative formatter is absent for the: ";
    private static Map<String, Format> defaultFormats = null;
    protected final ArrayList<CSVColumn> columns = new ArrayList();
    protected final HashMap<String, Format> userFormats = new HashMap();
    private String delimiter = ";";

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    private static void createDefaultFormatters() {
        defaultFormats = new HashMap<String, Format>();
        defaultFormats.put(FORMAT_STRING, new StringFormat());
        defaultFormats.put(FORMAT_COLOR_RGB_HEX, new ColorRGBHexFormat());
        defaultFormats.put(FORMAT_COLOR_RGB_TUPLE, new ColorRGBTupleFormat());
        defaultFormats.put(FORMAT_FLOAT_ARRAY, new FloatArrayFormat());
    }

    private static Format getDefaultFormat(String formatName) {
        if (defaultFormats == null) {
            CLUECSVParser.createDefaultFormatters();
        }
        Format l_formatter = defaultFormats.get(formatName);
        return l_formatter;
    }

    private Format formatFor(String formatName) {
        Format l_format = CLUECSVParser.getDefaultFormat(formatName);
        if (l_format == null) {
            l_format = this.userFormats.get(formatName);
        }
        return l_format;
    }

    public CSVColumn addColumn(int index, String field, String format) {
        CSVColumn l_column = new CSVColumn(index, field, format);
        this.columns.add(l_column);
        return l_column;
    }

    public void parse(String text, ColorChartEntry entry) throws ParseException {
        if (text == null || text.isEmpty()) {
            return;
        }
        String[] l_tokens = text.split(this.delimiter);
        if (l_tokens != null && l_tokens.length > 0) {
            for (CSVColumn c : this.columns) {
                int l_index = c.index;
                String l_token = l_index < l_tokens.length ? l_tokens[l_index] : null;
                if (l_token == null) continue;
                Format l_format = this.formatFor(c.format);
                if (l_format == null) {
                    throw new ParseException(ERR_NO_FORMAT + c.format, l_index);
                }
                Object l_value = l_format.parseObject(l_token);
                if (c.isLocalizedName()) {
                    entry.addLocalizedName((String)l_value, c.language, c.country);
                    continue;
                }
                entry.setField(c.field, l_value);
            }
        }
    }

    protected class CSVColumn {
        public final int index;
        public final String field;
        public final String format;
        private String language;
        private String country;

        public CSVColumn(int index, String field, String format) {
            this.index = index;
            this.field = field;
            this.format = format;
            this.country = null;
            this.language = null;
        }

        public void setLocale(String language, String country) {
            this.language = language;
            this.country = country;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getCountry() {
            return this.country;
        }

        public boolean isLocalizedName() {
            return this.field.equalsIgnoreCase("color_chart_entry.localized_name");
        }
    }
}

