/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColorLookupTable<V>
extends HashMap<Color, V> {
    private static final int BANK_NUM = 11;
    private boolean invalidated = true;
    private CLUTEntry[] grays = null;
    private final ArrayList<CLUTEntry[]> hues = new ArrayList();
    private static ColorDifferenceFormula formula = new DefaultColorDifferenceFormula();

    public static void setColorDifferenceFormula(ColorDifferenceFormula formula) {
        ColorLookupTable.formula = formula;
    }

    @Override
    public V put(Color color, V entry) {
        this.invalidated = true;
        return super.put(color, entry);
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected void validate() {
        this.hashEntries();
        this.invalidated = false;
    }

    protected void hashEntries() {
        Set l_entries = this.entrySet();
        ArrayList<CLUTEntry> l_grays = new ArrayList<CLUTEntry>();
        ArrayList l_hues = new ArrayList();
        for (int i = 0; i < 11; ++i) {
            l_hues.add(i, new ArrayList());
        }
        for (Map.Entry e : l_entries) {
            Color c = (Color)e.getKey();
            if (ColorLookupTable.isGrayscale(c)) {
                l_grays.add(this.createEntry(e));
                continue;
            }
            ((ArrayList)l_hues.get(this.getBank(c))).add(this.createEntry(e));
        }
        this.grays = l_grays.toArray(new CLUTEntry[l_grays.size()]);
        this.hues.clear();
        for (int i = 0; i < 11; ++i) {
            ArrayList l_bank = (ArrayList)l_hues.get(i);
            this.hues.add(i, l_bank.toArray(new CLUTEntry[l_bank.size()]));
        }
    }

    protected CLUTEntry createEntry(Color color, V value) {
        return new CLUTEntry(color, value);
    }

    protected CLUTEntry createEntry(Map.Entry<Color, V> entry) {
        return new CLUTEntry(entry.getKey(), entry.getValue());
    }

    protected int getBank(Color c) {
        float l_hue = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null)[0];
        return this.bankOf(l_hue);
    }

    protected int bankOf(float hue) {
        return (int)(hue * 10.0f + 0.5f);
    }

    protected float getOffset(Color c) {
        float l_hue = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null)[0];
        return (l_hue - (float)this.bankOf(l_hue) / 10.0f) * 10.0f;
    }

    public V getNearestEntry(Color color) {
        CLUTEntry l_match = null;
        if (this.invalidated) {
            this.validate();
        }
        int l_bankCount = this.hues.size();
        if (ColorLookupTable.isGrayscale(color)) {
            if (this.grays.length > 0) {
                l_match = this.search(this.grays, color);
            } else {
                for (CLUTEntry[] bank : this.hues) {
                    CLUTEntry l_entry = this.search(bank, color);
                    if (l_entry == null || l_match != null && !(l_entry.deviation < l_match.deviation)) continue;
                    l_match = l_entry;
                    if (l_match.deviation != 0.0f) continue;
                    break;
                }
            }
        } else {
            int l_index = this.getBank(color);
            float l_offset = this.getOffset(color);
            l_match = this.search(this.hues.get(l_index), color);
            if (l_match == null || l_match.deviation != 0.0f && Math.abs(l_offset) > 0.25f) {
                if ((l_index += l_offset > 0.0f ? 1 : -1) < 0) {
                    l_index = l_bankCount - 1;
                } else if (l_index >= l_bankCount) {
                    l_index = 0;
                }
                CLUTEntry l_entry = this.search(this.hues.get(l_index), color);
                if (l_entry != null) {
                    if (l_match != null) {
                        if (l_entry.deviation < l_match.deviation) {
                            l_match = l_entry;
                        }
                    } else {
                        l_match = l_entry;
                    }
                }
            }
        }
        return (V)(l_match != null ? l_match.value : null);
    }

    protected CLUTEntry search(CLUTEntry[] bank, Color color) {
        CLUTEntry l_entry = null;
        float l_deviation = 1000.0f;
        int l_count = 0;
        for (CLUTEntry e : bank) {
            Color c = e.color;
            ++l_count;
            if (color.equals(c)) {
                l_entry = e;
                l_deviation = 0.0f;
                break;
            }
            float d = formula.delta(color, c);
            if (!(d < l_deviation)) continue;
            l_entry = e;
            l_deviation = d;
        }
        if (l_entry != null) {
            l_entry.deviation = l_deviation;
        }
        return l_entry;
    }

    protected static boolean isGrayscale(Color c) {
        int g = c.getGreen();
        return c.getRed() == g && g == c.getBlue();
    }

    private static class DefaultColorDifferenceFormula
    implements ColorDifferenceFormula {
        private DefaultColorDifferenceFormula() {
        }

        @Override
        public float delta(Color c1, Color c2) {
            float[] l_colorComponents1 = c1.getColorComponents(null);
            float[] l_colorComponents2 = c2.getColorComponents(null);
            float l_delta = (float)Math.sqrt(Math.pow(Math.abs(l_colorComponents1[0] - l_colorComponents2[0]), 2.0) + Math.pow(Math.abs(l_colorComponents1[1] - l_colorComponents2[1]), 2.0) + Math.pow(Math.abs(l_colorComponents1[2] - l_colorComponents2[2]), 2.0));
            return l_delta;
        }
    }

    public static interface ColorDifferenceFormula {
        public float delta(Color var1, Color var2);
    }

    protected static class CLUTEntry {
        public final Color color;
        public final Object value;
        public float deviation;

        public CLUTEntry(Color color, Object value) {
            this.color = color;
            this.value = value;
            this.deviation = 0.0f;
        }
    }
}

