/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_chart;

import com.valeras.color_chart.ColorChartEntry;
import com.valeras.color_chart.ColorLookupTable;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class ColorChart
extends ColorSpace {
    private EntryIdentifier entryIdentifier;
    private String name = null;
    private String displayName = null;
    private static final ColorSpace cs_sRGB = ColorSpace.getInstance(1000);
    protected final ColorLookupTable<ColorChartEntry> clut;
    protected final ArrayList<ColorChartEntry> entries = new ArrayList();
    protected final ColorSpace colorSpace;

    public ColorChart() {
        super(cs_sRGB.getType(), cs_sRGB.getNumComponents());
        this.clut = new ColorLookupTable();
        this.entryIdentifier = EntryIdentifier.Code;
        this.colorSpace = cs_sRGB;
        this.name = null;
    }

    public ColorChart(String name) {
        super(cs_sRGB.getType(), cs_sRGB.getNumComponents());
        this.clut = new ColorLookupTable();
        this.entryIdentifier = EntryIdentifier.Code;
        this.name = name;
        this.colorSpace = cs_sRGB;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEntryIdentifier(EntryIdentifier ei) {
        this.entryIdentifier = ei;
    }

    public String getName() {
        return this.name;
    }

    public void putEntry(String code, String name, Color color) {
        ColorChartEntry l_entry = this.createEntry(code, name, color);
        this.clut.put(color, l_entry);
        this.entries.add(l_entry);
    }

    public void putEntry(ColorChartEntry entry) {
        this.clut.put(entry.getColor(), entry);
        this.entries.add(entry);
    }

    public ColorChartEntry getEntry(String identifier) {
        String l_id = identifier.toLowerCase();
        for (ColorChartEntry e : this.entries) {
            if (!l_id.equals(this.getEntryIdentifier(e).toLowerCase())) continue;
            return e;
        }
        return null;
    }

    public String getEntryIdentifier(ColorChartEntry entry) {
        return this.entryIdentifier == EntryIdentifier.Code ? entry.getCode() : entry.getName();
    }

    protected ColorChartEntry createEntry(String code, String name, Color color) {
        ColorChartEntry l_entry = new ColorChartEntry(this);
        l_entry.setColor(color);
        l_entry.setCode(code);
        l_entry.setName(name);
        return l_entry;
    }

    public ColorChartEntry getNearestEntry(Color color) {
        return this.clut.getNearestEntry(color);
    }

    public Collection<ColorChartEntry> entries() {
        Collection<ColorChartEntry> l_entries = this.entries != null ? this.entries : this.clut.values();
        return Collections.unmodifiableCollection(l_entries);
    }

    public int size() {
        return this.clut.size();
    }

    public Color getColor(String entryId) {
        ColorChartEntry l_entry = this.getEntry(entryId);
        return l_entry != null ? this.reproduceColor(l_entry.getColor()) : null;
    }

    public String identifierOf(Color color) {
        ColorChartEntry l_entry = (ColorChartEntry)this.clut.get(color);
        return l_entry != null ? this.getEntryIdentifier(l_entry) : null;
    }

    public Color matchColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        ColorChartEntry l_entry = this.clut.getNearestEntry(color);
        return l_entry != null ? this.reproduceColor(l_entry.getColor()) : null;
    }

    protected Color reproduceColor(Color color) {
        Color l_color;
        if (color == null) {
            return null;
        }
        if (this.colorSpace.equals(color.getColorSpace()) || !color.getColorSpace().isCS_sRGB() || !this.colorSpace.isCS_sRGB()) {
            l_color = new Color(this, color.getColorComponents(null), 1.0f);
        } else {
            float[] l_ciexyz = color.getColorSpace().toCIEXYZ(color.getColorComponents(null));
            float[] l_components = this.colorSpace.fromCIEXYZ(l_ciexyz);
            l_color = new Color(this, l_components, 1.0f);
        }
        return l_color;
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] l_colorComponents = this.colorSpace.fromCIEXYZ(colorvalue);
        Color l_color = new Color(this.colorSpace, l_colorComponents, 1.0f);
        return (l_color = this.matchColor(l_color)) != null ? l_color.getColorComponents(null) : null;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return this.colorSpace.toCIEXYZ(colorvalue);
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        return this.colorSpace.fromRGB(rgbvalue);
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (this.colorSpace.isCS_sRGB()) {
            return colorvalue;
        }
        return this.colorSpace.toRGB(colorvalue);
    }

    @Override
    public float getMaxValue(int component) {
        return this.colorSpace.getMaxValue(component);
    }

    @Override
    public float getMinValue(int component) {
        return this.colorSpace.getMinValue(component);
    }

    @Override
    public String getName(int idx) {
        return this.colorSpace.getName(idx);
    }

    @Override
    public int getNumComponents() {
        return this.colorSpace.getNumComponents();
    }

    @Override
    public int getType() {
        return this.colorSpace.getType();
    }

    @Override
    public boolean isCS_sRGB() {
        return this.colorSpace.isCS_sRGB();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    public BufferedImage getLogoImage() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static enum EntryIdentifier {
        Code,
        Name;

    }
}

