/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.view.renderer;

import com.valeras.color_combine.model.ColorWheel;
import com.valeras.color_combine.view.geometry.Pie2D;
import com.valeras.color_combine.view.renderer.ColorWheelSkin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;

public abstract class AbstractColorWheelRenderer {
    protected ColorWheel colorWheel = null;
    protected Pie2D geometry;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected ColorWheelSkin skin;
    private double rotate;
    private boolean renderObscuredSector;
    private boolean invalidated;

    protected AbstractColorWheelRenderer(int width, int height, ColorWheelSkin skin) {
        this.skin = skin;
        this.geometry = null;
        this.x = 0;
        this.y = 0;
        this.width = width;
        this.height = height;
        this.renderObscuredSector = skin.isTransparent();
        this.rotate = 0.0;
        this.invalidated = true;
    }

    protected boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidated(boolean flag) {
        this.invalidated = flag;
    }

    protected void validate() {
        this.geometry = new Pie2D(this.x, this.y, this.width, this.height, this.colorWheel.getSectorCount(), this.colorWheel.getVariationCount());
        this.geometry.setInnerMargin(this.skin.getHoleSize() / 2);
        this.geometry.setOuterMargin(this.skin.getOuterMargin());
        this.invalidated = false;
    }

    public void setColorWheel(ColorWheel colorWheel) {
        this.colorWheel = colorWheel;
    }

    public void setSkin(ColorWheelSkin skin) {
        this.skin = skin;
        this.setInvalidated(true);
    }

    public ColorWheelSkin getSkin() {
        return this.skin;
    }

    public void setFrame(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setInvalidated(true);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    protected void setRenderObscuredSectorEnabled(boolean flag) {
        this.renderObscuredSector = flag;
    }

    protected final boolean isRenderObscuredSectorEnabled() {
        return this.renderObscuredSector;
    }

    protected boolean isSegmentObscured(int index) {
        return false;
    }

    public void setRotate(double angle) {
        this.rotate = angle;
    }

    protected void renderWheel(Graphics g) {
        int l_count = this.colorWheel.getSectorCount();
        for (int i = 0; i < l_count; ++i) {
            if (!this.isRenderObscuredSectorEnabled() && this.isSegmentObscured(i)) continue;
            this.renderSector(g, i);
        }
    }

    protected void renderSector(Graphics g, int index) {
        if (index < 0 || index >= this.colorWheel.getSectorCount()) {
            throw new IllegalArgumentException("Invalid sector index: " + index);
        }
        int l_count = this.colorWheel.getVariationCount();
        int l_index = this.getAbsoluteSectorIndex(index);
        for (int i = 0; i < l_count; ++i) {
            Shape l_stripe = this.geometry.getStripe(l_index, i);
            Color l_color = this.colorWheel.getVariationColor(l_index, i);
            this.renderColorStripe(g, l_stripe, l_color);
        }
    }

    public int getAbsoluteSectorIndex(int index) {
        int l_count = this.colorWheel.getSectorCount();
        int l_index = this.colorWheel.getIndex0() + index;
        if (l_index < 0) {
            l_index += l_count;
        } else if (l_index >= l_count) {
            l_index -= l_count;
        }
        return l_index;
    }

    protected abstract void renderColorStripe(Graphics var1, Shape var2, Color var3);

    protected abstract void renderCover(Graphics var1, ColorWheelSkin var2);

    public void render(Graphics g) {
        if (this.colorWheel == null) {
            throw new RuntimeException("Set the color wheel first.");
        }
        if (this.invalidated) {
            this.validate();
        }
        this.geometry.setAngleStart(this.rotate);
        this.renderWheel(g);
        this.renderCover(g, this.skin);
    }
}

