/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.view.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class Pie2D
extends Ellipse2D.Double {
    private static final double PIXEL_TO_DEGREE = 57.29577951308232;
    private final int sliceCount;
    private final int stripeCount;
    private final double sectorExtent;
    private double angleStart;
    private double innerMargin;
    private double outerMargin;
    private double leftGap;
    private double rightGap;

    public Pie2D(double x, double y, double w, double h, int sliceCount, int stripeCount) {
        super(x, y, w, h);
        this.sliceCount = sliceCount;
        this.stripeCount = stripeCount;
        this.sectorExtent = 360.0 / (double)this.sliceCount;
        this.angleStart = 0.0;
        this.innerMargin = 0.0;
        this.outerMargin = 0.0;
        this.rightGap = 0.0;
        this.leftGap = 0.0;
    }

    public final int getSliceCount() {
        return this.sliceCount;
    }

    public final int getStripeCount() {
        return this.stripeCount;
    }

    public final double getSliceExtent() {
        return this.sectorExtent;
    }

    public final double getAngleStart() {
        return this.angleStart;
    }

    public void setAngleStart(double angle) {
        this.angleStart = angle;
    }

    public final double getInnerMargin() {
        return this.innerMargin;
    }

    public void setInnerMargin(double margin) {
        this.innerMargin = margin;
    }

    public final double getOuterMargin() {
        return this.outerMargin;
    }

    public void setOuterMargin(double margin) {
        this.outerMargin = margin;
    }

    public void setSliceGap(double gap) {
        this.leftGap = gap;
        this.rightGap = gap;
    }

    public double getSliceGap() {
        return this.leftGap;
    }

    public Ellipse2D getInnerEllipse() {
        Ellipse2D.Double l_ellipse = new Ellipse2D.Double();
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        l_ellipse.setFrameFromCenter(cx, cy, cx + this.innerMargin, cy + this.innerMargin);
        return l_ellipse;
    }

    public int sectorAt(Point2D point) {
        for (int i = 0; i < this.sliceCount; ++i) {
            Arc2D l_sector = this.getSector(i);
            if (!l_sector.contains(point)) continue;
            return i;
        }
        return -1;
    }

    public int sliceAt(Point2D point) {
        for (int i = 0; i < this.sliceCount; ++i) {
            Shape l_slice = this.getSlice(i);
            if (!l_slice.contains(point)) continue;
            return i;
        }
        return -1;
    }

    public int stripeAt(Point2D point) {
        double l_distance = point.distance(this.getCenterX(), this.getCenterY());
        if (l_distance > this.innerMargin && l_distance < this.getWidth() / 2.0 - this.outerMargin) {
            return (int)((l_distance - this.innerMargin) / this.getStripeThickness());
        }
        return -1;
    }

    public static double angleAt(double x, double y) {
        double l_angle = 0.0;
        if (y == 0.0) {
            l_angle = x >= 0.0 ? 0.0 : 180.0;
            return l_angle;
        }
        l_angle = Math.toDegrees(Math.atan(Math.abs(x / y)));
        if (x >= 0.0 && y >= 0.0) {
            l_angle = 90.0 - l_angle;
        } else if (x < 0.0 && y >= 0.0) {
            l_angle += 90.0;
        } else if (x < 0.0 && y < 0.0) {
            l_angle = 270.0 - l_angle;
        } else if (x >= 0.0 && y < 0.0) {
            l_angle += 270.0;
        }
        return l_angle;
    }

    public Arc2D getSector(int index) {
        return new Arc2D.Double(this.x, this.y, this.width, this.height, this.angleStart + this.sectorExtent * (double)index, this.sectorExtent, 2);
    }

    public Arc2D getSector(int index, float angleStart) {
        return new Arc2D.Double(this.x, this.y, this.width, this.height, (double)angleStart + this.sectorExtent * (double)index, this.sectorExtent, 2);
    }

    public Arc2D getInnerSector(int index) {
        return new Arc2D.Double(this.getInnerEllipse().getBounds(), this.angleStart + this.sectorExtent * (double)index, this.sectorExtent, 2);
    }

    public Arc2D getInnerSector(int index, double angleStart) {
        return new Arc2D.Double(this.getInnerEllipse().getBounds(), angleStart + this.sectorExtent * (double)index, this.sectorExtent, 2);
    }

    public Shape getSlice(int index) {
        return this.getSlice(index, this.angleStart, 1);
    }

    public Shape getSlice(int index, double angleStart, int sectors) {
        Path2D.Double l_path = new Path2D.Double();
        double l_radiusInner = this.innerMargin;
        double l_radiusOuter = this.getWidth() / 2.0 - this.outerMargin;
        Arc2D l_arcInner = this.arcAt(index, l_radiusInner, angleStart, sectors, true);
        Arc2D l_arcOuter = this.arcAt(index, l_radiusOuter, angleStart, sectors, false);
        ((Path2D)l_path).moveTo(0.0, 0.0);
        l_path.append(l_arcInner, false);
        l_path.append(l_arcOuter, true);
        l_path.closePath();
        return l_path;
    }

    public double getStripeThickness() {
        return (this.getWidth() / 2.0 - this.innerMargin - this.outerMargin) / (double)this.stripeCount;
    }

    public Shape getStripe(int sliceIndex, int stripeIndex) {
        Path2D.Double l_stripe = new Path2D.Double();
        double l_step = this.getStripeThickness();
        double l_radiusInner = this.innerMargin + l_step * (double)stripeIndex;
        double l_radiusOuter = this.innerMargin + l_step * (double)(stripeIndex + 1);
        Arc2D l_arcInner = this.arcAt(sliceIndex, l_radiusInner, this.angleStart, 1, true);
        Arc2D l_arcOuter = this.arcAt(sliceIndex, l_radiusOuter, this.angleStart, 1, false);
        l_stripe.moveTo(0.0, 0.0);
        l_stripe.append(l_arcInner, false);
        l_stripe.append(l_arcOuter, true);
        l_stripe.closePath();
        return l_stripe;
    }

    public Point2D getStripeCP(int sectorIndex, int stripeIndex) {
        Point2D l_pnt = null;
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        double l_theta = this.angleStart + ((double)sectorIndex + 0.5) * this.sectorExtent;
        AffineTransform l_tx = AffineTransform.getRotateInstance(Math.toRadians(-l_theta), cx, cy);
        double l_dx = this.innerMargin + this.getStripeThickness() * ((double)stripeIndex + 0.5);
        l_pnt = l_tx.transform(new Point2D.Double(cx + l_dx, cy), null);
        return l_pnt;
    }

    public Arc2D getSliceOuterArc(int index) {
        double l_radius = this.getWidth() / 2.0 - this.outerMargin;
        Arc2D l_arc = this.arcAt(index, l_radius, this.angleStart, 1, true);
        return l_arc;
    }

    public Arc2D getSliceInnerArc(int index) {
        double l_radius = this.getWidth() / 2.0 - this.innerMargin;
        Arc2D l_arc = this.arcAt(index, l_radius, this.angleStart, 1, true);
        return l_arc;
    }

    public Arc2D getStripeArc(int sector, int index, float param) {
        return this.getStripeArc(sector, index, param, this.angleStart);
    }

    public Arc2D getStripeArc(int sector, int index, float param, double angle) {
        double l_step = this.getStripeThickness();
        double l_radius = this.innerMargin + l_step * (double)((float)index + param);
        Arc2D l_arc = this.arcAt(sector, l_radius, angle, 1, false);
        return l_arc;
    }

    protected Arc2D arcAt(int index, double r, double angleStart, int sectors, boolean counterClockwise) {
        double l_extent;
        double l_start;
        double l_leftGap = this.leftGap * (57.29577951308232 / r);
        double l_rightGap = this.rightGap * (57.29577951308232 / r);
        double l_angleStart = angleStart + this.sectorExtent * (double)index;
        if (counterClockwise) {
            l_start = l_angleStart + l_rightGap;
            l_extent = this.sectorExtent * (double)sectors - (l_leftGap + l_rightGap);
        } else {
            l_start = l_angleStart + this.sectorExtent * (double)sectors - l_leftGap;
            l_extent = -(this.sectorExtent * (double)sectors - (l_leftGap + l_rightGap));
        }
        Arc2D.Double l_arc = new Arc2D.Double(this.getCenterX() - r, this.getCenterY() - r, r * 2.0, r * 2.0, l_start, l_extent, 0);
        return l_arc;
    }
}

