/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model.color_tuners;

import com.valeras.color_combine.model.ColorMixing;
import com.valeras.color_combine.model.color_tuners.AbstractVariateColorTuner;
import java.awt.Color;

public class Default3X3VariateColorTuner
extends AbstractVariateColorTuner {
    private static final String COLOR_ENTITY_NAME = "color_tuner.3x3_variate";
    private static final int DEFAULT_ROW_COUNT = 3;
    private static final int DEFAULT_COLUMN_COUNT = 3;
    protected static final float DEFAULT_DEVIATION = 0.1f;
    protected final int columnCount;
    protected final int rowCount;
    private final int count;

    public Default3X3VariateColorTuner() {
        super(9);
        this.rowCount = 3;
        this.columnCount = 3;
        this.count = this.rowCount * this.columnCount;
    }

    public final int indexAt(int column, int row) {
        return row * this.columnCount + column;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    @Override
    protected void variate(Color color) {
        if (color == null) {
            for (int i = 0; i < this.count; ++i) {
                this.setVariation(i, null);
            }
            return;
        }
        this.setVariation(0, ColorMixing.tint(color, 0.1f));
        this.setVariation(1, ColorMixing.tint(color, 0.2f));
        this.setVariation(2, ColorMixing.tint(color, 0.3f));
        this.setVariation(3, !Default3X3VariateColorTuner.isGrayscale(color) ? ColorMixing.tone(color, -0.1f) : ColorMixing.adjust(color, 0.0f, 0.0f, 0.1f));
        this.setVariation(4, color);
        this.setVariation(5, !Default3X3VariateColorTuner.isGrayscale(color) ? ColorMixing.tone(color, 0.1f) : ColorMixing.adjust(color, 0.0f, 0.0f, -0.1f));
        this.setVariation(6, ColorMixing.shade(color, 0.1f));
        this.setVariation(7, ColorMixing.shade(color, 0.2f));
        this.setVariation(8, ColorMixing.shade(color, 0.3f));
    }

    @Override
    public String getName() {
        return COLOR_ENTITY_NAME;
    }

    protected static boolean isGrayscale(Color c) {
        int g = c.getGreen();
        return c.getRed() == g && g == c.getBlue();
    }
}

