/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model.color_tuners;

import com.valeras.color_combine.model.VariateColorTuner;
import java.awt.Color;
import java.util.Arrays;

public abstract class AbstractVariateColorTuner
implements VariateColorTuner {
    private final Color[] variations;
    private Color color = null;

    public AbstractVariateColorTuner(int count) {
        this.variations = new Color[count];
    }

    protected void setVariation(int index, Color color) {
        if (index < 0 || index >= this.variations.length) {
            throw new RuntimeException("Invalid index.");
        }
        this.variations[index] = color;
    }

    @Override
    public Color getVariation(int index) {
        if (index < 0 || index >= this.variations.length) {
            throw new RuntimeException("Invalid index.");
        }
        return this.variations[index];
    }

    @Override
    public Color[] getVariations() {
        return Arrays.copyOf(this.variations, this.variations.length);
    }

    @Override
    public final int getVariationCount() {
        return this.variations.length;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.variate(color);
    }

    @Override
    public Color getOriginalColor() {
        return this.color;
    }

    protected abstract void variate(Color var1);

    public String toString() {
        return this.getName();
    }
}

