/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model;

import com.valeras.color_combine.model.ColorProducer;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.color_combine.model.ColorSpectrum;
import java.awt.Color;
import java.awt.Point;

public class ColorWheel
implements ColorProducer {
    public static final String NAME = "color_wheel";
    private ColorScheme colorScheme = null;
    private int index0 = 0;
    private final ColorSpectrum spectrum;
    private boolean inverse;

    public ColorWheel(ColorSpectrum spectrum) {
        this.spectrum = spectrum;
        this.inverse = false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public ColorSpectrum getSpectrum() {
        return this.spectrum;
    }

    public void setInverse(boolean flag) {
        this.inverse = flag;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public String getColorModel() {
        return "color_wheel.color_model.ryb";
    }

    public int getVariationCount() {
        return this.spectrum.getRangeSize();
    }

    @Override
    public void setColorScheme(ColorScheme scheme) {
        this.colorScheme = scheme;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public int getSectorCount() {
        return this.spectrum.size();
    }

    public void setIndex0(int index) {
        if (this.index0 < 0 || this.index0 >= this.spectrum.size()) {
            throw new RuntimeException("setIndex0() invalid argument: " + index);
        }
        this.index0 = index;
    }

    public int getIndex0() {
        return this.index0;
    }

    public float getSectorExtent() {
        return 360.0f / (float)this.spectrum.size();
    }

    public int indexInSpectrum(int index) {
        if (!this.inverse) {
            return index;
        }
        return index == 0 ? 0 : this.spectrum.size() - index;
    }

    protected int indexInWheel(int index) {
        return !this.inverse ? index : (index == 0 ? 0 : this.spectrum.size() - index);
    }

    public int getWarmColorsStartIndex() {
        int l_size = this.spectrum.size();
        int l_index = this.spectrum.getWarmColorsStartIndex();
        if (this.inverse && (l_index = this.indexInWheel(l_index) + l_size / 2 + 1) >= l_size) {
            l_index -= l_size;
        }
        return l_index;
    }

    public int getCoolColorsStartIndex() {
        int l_size = this.spectrum.size();
        int l_index = this.spectrum.getCoolColorsStartIndex();
        if (this.inverse && (l_index = this.indexInWheel(l_index) + l_size / 2 + 1) >= l_size) {
            l_index -= l_size;
        }
        return l_index;
    }

    public Color getColor(int index) {
        return this.spectrum.getColor(this.indexInSpectrum(index));
    }

    public Color getVariationColor(int sector, int variation) {
        return this.spectrum.getRange(this.indexInSpectrum(sector))[variation];
    }

    public Point pointOf(Color color) {
        Point l_pnt = null;
        int l_sector = -1;
        int l_variation = -1;
        int l_index = this.spectrum.indexOf(color);
        if (l_index >= 0 && (l_variation = this.spectrum.indexInRange(color, l_index)) >= 0) {
            l_sector = this.indexInWheel(l_index);
            l_pnt = new Point(l_sector, l_variation);
        }
        return l_pnt;
    }

    public boolean isSectorEnabled(int index) {
        boolean l_enabled = true;
        int l_sectorCount = this.getSectorCount();
        if (index < 0 || index >= this.getSectorCount()) {
            throw new RuntimeException("Sector index is out of bounds: " + index);
        }
        if (this.colorScheme != null) {
            int l_schemeAlignIndex = (int)(this.colorScheme.getAlignmentAngle() / (double)this.getSectorExtent());
            int l_index = index + this.index0 - l_schemeAlignIndex;
            if (l_index >= l_sectorCount) {
                l_index -= l_sectorCount;
            } else if (l_index < 0) {
                l_index += l_sectorCount;
            }
            l_enabled = this.colorScheme.getMask()[l_index];
        }
        return l_enabled;
    }
}

