/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model;

import com.valeras.color_combine.model.VariateColorTuner;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class ColorSpectrum {
    private final Color[] colors;
    private final String[] names;
    private final float[] hues;
    private final ArrayList<Color[]> ranges;
    private final VariateColorTuner variator;
    private int count;
    private int warmColorsStartIndex;
    private int coolColorsStartIndex;

    public ColorSpectrum(Color[] colors, String[] names, VariateColorTuner variator) {
        int i;
        this.count = colors.length;
        this.colors = new Color[this.count];
        this.variator = variator;
        System.arraycopy(colors, 0, this.colors, 0, this.count);
        String[] stringArray = this.names = names != null ? new String[this.count] : null;
        if (names != null) {
            System.arraycopy(names, 0, this.names, 0, this.count);
        }
        this.hues = new float[this.count];
        for (i = 0; i < this.count; ++i) {
            this.hues[i] = ColorSpectrum.hueOf(this.colors[i]);
        }
        this.ranges = new ArrayList();
        for (i = 0; i < this.count; ++i) {
            variator.setColor(this.colors[i]);
            this.ranges.add(i, variator.getVariations());
        }
        this.coolColorsStartIndex = -1;
        this.warmColorsStartIndex = -1;
    }

    public Color getColor(int index) {
        return this.colors[index];
    }

    public String getColorName(int index) {
        return this.names != null ? this.names[index] : null;
    }

    private static float hueOf(Color color) {
        float[] l_hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return l_hsb[0];
    }

    public int indexOf(Color color) {
        return ColorSpectrum.indexOf(this.hues, ColorSpectrum.hueOf(color));
    }

    public int indexInRange(Color color, int range) {
        int l_index = -1;
        float l_min = 100.0f;
        Color[] l_range = this.ranges.get(range);
        int l_count = l_range.length;
        float[] l_colorComponents = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        for (int i = 0; i < l_count; ++i) {
            Color l_color = l_range[i];
            float[] l_colorComponents2 = Color.RGBtoHSB(l_color.getRed(), l_color.getGreen(), l_color.getBlue(), null);
            float l_deltaS = l_colorComponents[1] - l_colorComponents2[1];
            float l_deltaB = l_colorComponents[2] - l_colorComponents2[2];
            float l_delta = (float)Math.sqrt(l_deltaS * l_deltaS + l_deltaB * l_deltaB);
            if (l_index != -1 && !(l_delta < l_min)) continue;
            l_min = l_delta;
            l_index = i;
        }
        return l_index;
    }

    private static int indexOf(float[] values, float key) {
        int l_index = -1;
        float l_min = 0.0f;
        float l_delta = 0.0f;
        int l_count = values.length;
        for (int i = 0; i < l_count; ++i) {
            l_delta = Math.abs(key - values[i]);
            if (l_index != -1 && !(l_delta < l_min)) continue;
            l_index = i;
            l_min = l_delta;
        }
        if (l_index == l_count - 1 && key > values[l_count - 1]) {
            if (Math.abs(values[0] + 1.0f - key) < l_delta) {
                l_index = 0;
            }
        } else if (l_index == 0 && key < values[0]) {
            l_delta = Math.abs(key - values[0]);
            if (Math.abs(1.0f - values[l_count - 1] + key) < l_delta) {
                l_index = l_count - 1;
            }
        }
        return l_index;
    }

    private static int indexOf2(float[] values, float key) {
        float WRAP_MAX = 1.0f;
        float WRAP_MIN = 0.0f;
        int l_index = Arrays.binarySearch(values, key);
        if (l_index < 0) {
            int l_index2 = (l_index = -(l_index + 1)) - 1;
            if (l_index2 < 0) {
                l_index2 = values.length - 1;
                float l_d = Math.abs(key - values[l_index]);
                float l_d2 = Math.abs(key - 0.0f);
                if (l_d2 < l_d) {
                    l_index = l_index2;
                }
            } else if (l_index >= values.length) {
                l_index = 0;
                float l_d = Math.abs(1.0f - key + (values[0] - 0.0f));
                float l_d2 = Math.abs(key - values[l_index2]);
                if (l_d2 < l_d) {
                    l_index = l_index2;
                }
            } else {
                float l_d = Math.abs(key - values[l_index]);
                float l_d2 = Math.abs(key - values[l_index2]);
                if (l_d2 < l_d) {
                    l_index = l_index2;
                }
            }
        }
        return l_index;
    }

    public int size() {
        return this.count;
    }

    public int getRangeSize() {
        return this.variator.getVariationCount();
    }

    public Color[] getRange(int index) {
        return this.ranges.get(index);
    }

    public int getWarmColorsStartIndex() {
        if (this.warmColorsStartIndex == -1) {
            this.seekWarmCoolRange();
        }
        return this.warmColorsStartIndex;
    }

    public int getCoolColorsStartIndex() {
        if (this.coolColorsStartIndex == -1) {
            this.seekWarmCoolRange();
        }
        return this.coolColorsStartIndex;
    }

    public static boolean isWarmColor(Color color) {
        return !ColorSpectrum.isColdColor(color);
    }

    public static boolean isColdColor(Color color) {
        float l_hue = ColorSpectrum.hueOf(color);
        return l_hue > 0.18f && l_hue < 0.8f;
    }

    private void seekWarmCoolRange() {
        boolean l_lastCold = ColorSpectrum.isColdColor(this.colors[0]);
        for (int i = 1; i < this.count; ++i) {
            if (ColorSpectrum.isColdColor(this.colors[i])) {
                if (!l_lastCold && this.coolColorsStartIndex == -1) {
                    this.coolColorsStartIndex = i;
                }
                l_lastCold = true;
                continue;
            }
            if (ColorSpectrum.isWarmColor(this.colors[i]) && l_lastCold && this.warmColorsStartIndex == -1) {
                this.warmColorsStartIndex = i;
            }
            l_lastCold = false;
        }
        if (this.coolColorsStartIndex == -1) {
            this.coolColorsStartIndex = 0;
        }
        if (this.warmColorsStartIndex == -1) {
            this.coolColorsStartIndex = 0;
        }
    }
}

