/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ColorPalette
extends ArrayList<Color> {
    private final Map<Integer, String> labels = new HashMap<Integer, String>();

    public ColorPalette() {
    }

    public ColorPalette(int size) {
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            this.add(null);
        }
    }

    public String getLabel(int index) {
        return this.labels.get(index);
    }

    public void setLabel(int index, String text) {
        if (text == null || text.isEmpty()) {
            this.labels.remove(index);
        } else {
            this.labels.put(index, text);
        }
    }

    public Color[] getColors() {
        Color[] l_colors = new Color[this.size()];
        return this.toArray(l_colors);
    }

    public void setPalette(ColorPalette palette) {
        this.overwritePalette(palette, true);
    }

    public void overwritePalette(ColorPalette palette, boolean trim) {
        int i;
        int l_size = this.size();
        int l_size2 = palette.size();
        for (i = 0; i < l_size2; ++i) {
            Color l_color = (Color)palette.get(i);
            String l_label = palette.getLabel(i);
            if (i < l_size) {
                this.set(i, l_color);
            } else {
                this.add(l_color);
            }
            this.labels.remove(i);
            if (l_label == null) continue;
            this.labels.put(i, l_label);
        }
        if (trim && l_size2 < l_size) {
            for (i = l_size2; i < l_size; ++i) {
                this.labels.remove(i);
            }
            this.removeRange(l_size2, l_size);
            this.trimToSize();
        }
    }
}

