/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.model;

import java.awt.Color;

public class ColorMixing {
    public static Color mix(Color c1, Color c2) {
        return ColorMixing.mix(c1, c2, 0.5f);
    }

    public static Color mix(Color primary, Color color2, float amount) {
        float l_base = 1.0f - amount;
        int r = (int)(l_base * (float)primary.getRed() + amount * (float)color2.getRed());
        int g = (int)(l_base * (float)primary.getGreen() + amount * (float)color2.getGreen());
        int b = (int)(l_base * (float)primary.getBlue() + amount * (float)color2.getBlue());
        return new Color(r, g, b);
    }

    public static Color tint(Color color, float amount) {
        return ColorMixing.adjust(color, 0.0f, -amount, 0.0f);
    }

    public static Color shade(Color color, float amount) {
        return ColorMixing.adjust(color, 0.0f, 0.0f, -amount);
    }

    public static Color tone(Color color, float amount) {
        return ColorMixing.adjust(color, 0.0f, -amount, -amount);
    }

    public static Color adjust(Color color, float dh, float ds, float db) {
        if (color == null) {
            throw new NullPointerException();
        }
        float[] l_hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        l_hsb[0] = l_hsb[0] + dh;
        l_hsb[1] = l_hsb[1] + ds;
        l_hsb[2] = l_hsb[2] + db;
        l_hsb[0] = ColorMixing.wrap(l_hsb[0]);
        l_hsb[1] = ColorMixing.normalize(l_hsb[1]);
        l_hsb[2] = ColorMixing.normalize(l_hsb[2]);
        Color l_color = Color.getHSBColor(l_hsb[0], l_hsb[1], l_hsb[2]);
        return l_color;
    }

    private static float normalize(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    private static float wrap(float value) {
        if (value < 0.0f) {
            return 1.0f + value;
        }
        if (value > 1.0f) {
            return value - 1.0f;
        }
        return value;
    }
}

