/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.controller;

import com.valeras.color_combine.controller.VariateColorTunerController;
import com.valeras.color_combine.events.ColorChangeEvent;
import com.valeras.color_combine.events.ColorChangeListener;
import com.valeras.color_combine.events.ColorProduceEvent;
import com.valeras.color_combine.events.ColorProduceListener;
import com.valeras.color_combine.model.VariateColorTuner;
import java.awt.Color;
import java.util.ArrayList;

public abstract class AbstractVariateColorTunerController
implements VariateColorTunerController {
    protected final ArrayList<ColorProduceListener> colorProduceListeners = new ArrayList();
    protected final ArrayList<ColorChangeListener> colorChangeListeners = new ArrayList();
    protected VariateColorTuner model = null;
    private int selectedIndex = -1;
    private boolean enabled = true;

    protected AbstractVariateColorTunerController() {
    }

    @Override
    public VariateColorTuner getModel() {
        return this.model;
    }

    @Override
    public void setModel(VariateColorTuner model) {
        this.model = model;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setColor(Color color) {
        this.model.setColor(color);
        this.fireColorChanged(new ColorChangeEvent(this, color));
    }

    @Override
    public Color getColor() {
        return this.model.getColor();
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getVariationCount() {
        return this.model.getVariationCount();
    }

    @Override
    public Color getVariation(int index) {
        return this.model.getVariation(index);
    }

    @Override
    public void approve() {
        Color l_color = this.model.getVariation(this.selectedIndex);
        ColorProduceEvent l_event = new ColorProduceEvent(this, l_color);
        this.fireColorProduced(l_event);
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.colorChangeListeners.add(listener);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.colorChangeListeners.remove(listener);
    }

    protected void fireColorChanged(ColorChangeEvent event) {
        for (ColorChangeListener l : this.colorChangeListeners) {
            l.colorChanged(event);
        }
    }

    @Override
    public void addColorProduceListener(ColorProduceListener listener) {
        this.colorProduceListeners.add(listener);
    }

    protected void fireColorProduced(ColorProduceEvent event) {
        for (ColorProduceListener l : this.colorProduceListeners) {
            l.colorProduced(event);
        }
    }

    @Override
    public void removeColorProduceListener(ColorProduceListener listener) {
        this.colorProduceListeners.remove(listener);
    }
}

