/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.controller;

import com.valeras.color_combine.controller.SampleColorProducerController;
import com.valeras.color_combine.events.ColorProduceEvent;
import com.valeras.color_combine.events.ColorProduceListener;
import com.valeras.color_combine.model.ColorProducer;
import com.valeras.color_combine.model.ColorScheme;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractSampleColorProducerController<T extends ColorProducer>
implements SampleColorProducerController {
    protected T model = null;
    protected Color sampledColor = null;
    private boolean enabled = true;
    protected final ArrayList<ColorProduceListener> colorProduceListeners = new ArrayList();
    protected final ArrayList<ChangeListener> changeListeners = new ArrayList();
    protected final ChangeEvent defaultChangeEvent = new ChangeEvent(this);

    protected AbstractSampleColorProducerController() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ColorProducer getModel() {
        return this.model;
    }

    @Override
    public void setModel(ColorProducer model) {
        this.model = model;
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        this.model.setColorScheme(colorScheme);
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    protected void fireColorProduceEvent(ColorProduceEvent event) {
        this.sampledColor = event.getColor();
        for (ColorProduceListener l : this.colorProduceListeners) {
            l.colorProduced(event);
        }
    }

    @Override
    public Color getColor() {
        return this.sampledColor;
    }

    @Override
    public void addColorProduceListener(ColorProduceListener l) {
        this.colorProduceListeners.add(l);
    }

    @Override
    public void removeColorProduceListener(ColorProduceListener l) {
        this.colorProduceListeners.remove(l);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }
}

