/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.controller;

import com.valeras.color_combine.controller.AbstractSampleColorProducerController;
import com.valeras.color_combine.controller.ColorWheelController;
import com.valeras.color_combine.events.ColorProduceEvent;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.color_combine.model.ColorWheel;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorWheelController
extends AbstractSampleColorProducerController<ColorWheel>
implements ColorWheelController {
    private static final float RECTIFY_TRESHOLD = 0.3f;
    private float rotate;
    private final ArrayList<ChangeListener> turnListeners;

    protected AbstractColorWheelController() {
        this.model = null;
        this.turnListeners = new ArrayList();
        this.rotate = 0.0f;
    }

    @Override
    public void setModel(ColorWheel model) {
        this.rotate = 0.0f;
        super.setModel(model);
    }

    @Override
    public void turn(int turns) {
        int l_count = ((ColorWheel)this.model).getSectorCount();
        int l_index = ((ColorWheel)this.model).getIndex0();
        if ((l_index += turns) < 0) {
            l_index += l_count;
        } else if (l_index >= l_count) {
            l_index -= l_count;
        }
        ((ColorWheel)this.model).setIndex0(l_index);
        this.fireRotateEvent(new ChangeEvent(this));
    }

    @Override
    public void rotate(float angle) {
        this.setRotate(this.rotate + angle);
    }

    @Override
    public void rectify(int direction) {
        float l_extent = ((ColorWheel)this.model).getSectorExtent();
        if (this.rotate == 0.0f) {
            return;
        }
        float l_abc = Math.abs(this.rotate / l_extent);
        float l_angle = direction >= 0 ? (l_abc > 0.3f ? l_extent : 0.0f) : (l_abc > 0.3f ? -l_extent : 0.0f);
        this.setRotate(l_angle);
    }

    protected void setRotate(float angle) {
        float l_extent = ((ColorWheel)this.model).getSectorExtent();
        int l_turns = (int)(angle / l_extent);
        if (l_turns != 0) {
            this.turn(l_turns);
        }
        this.rotate = angle - (float)l_turns * l_extent;
        this.fireRotateEvent(new ChangeEvent(this));
    }

    @Override
    public void sample(int sector, int stripe) {
        this.sampledColor = ((ColorWheel)this.model).getVariationColor(sector, stripe);
        ColorProduceEvent l_event = new ColorProduceEvent(this, this.sampledColor);
        this.fireColorProduceEvent(l_event);
    }

    @Override
    public float getRotate() {
        ColorScheme l_colorScheme = ((ColorWheel)this.model).getColorScheme();
        float l_angleStart = 15.0f;
        float l_rotate = (float)((ColorWheel)this.model).getIndex0() * ((ColorWheel)this.model).getSectorExtent() + this.rotate;
        if (l_colorScheme != null) {
            l_rotate += 15.0f;
        }
        return l_rotate;
    }

    @Override
    public void addRotateChangeListener(ChangeListener l) {
        this.turnListeners.add(l);
    }

    @Override
    public void removeRotateChangeListener(ChangeListener l) {
        this.turnListeners.remove(l);
    }

    protected void fireRotateEvent(ChangeEvent e) {
        for (ChangeListener l : this.turnListeners) {
            l.stateChanged(e);
        }
    }
}

