/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.controller;

import com.valeras.color_combine.controller.ColorPaletteController;
import com.valeras.color_combine.model.ColorPalette;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorPaletteController
implements ColorPaletteController {
    protected ColorPalette colorPalette = null;
    private int selectedIndex = 0;
    private boolean enabled = true;
    protected final ArrayList<ItemListener> itemListeners = new ArrayList();
    protected final ArrayList<ChangeListener> changeListeners = new ArrayList();
    protected final ChangeEvent defaultChangeEvent = new ChangeEvent(this);

    protected AbstractColorPaletteController() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setModel(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
        this.selectedIndex = 0;
    }

    @Override
    public ColorPalette getModel() {
        return this.colorPalette;
    }

    @Override
    public void setColor(int index, Color color) {
        this.colorPalette.set(index, color);
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= this.colorPalette.size()) {
            throw new RuntimeException("Index is out of bounds.");
        }
        if (this.selectedIndex != index) {
            ItemEvent e;
            if (this.selectedIndex != -1) {
                e = new ItemEvent(this, 701, this.colorPalette.get(this.selectedIndex), 2);
                this.fireItemStateChanged(e);
            }
            this.selectedIndex = index;
            if (index >= 0) {
                e = new ItemEvent(this, 701, this.colorPalette.get(this.selectedIndex), 1);
                this.fireItemStateChanged(e);
            }
        }
    }

    @Override
    public void setLabel(int index, String text) {
        this.colorPalette.setLabel(index, text);
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    @Override
    public void updateColorPalette(ColorPalette palette) {
        this.colorPalette.setPalette(palette);
        this.selectedIndex = 0;
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    protected void fireItemStateChanged(ItemEvent event) {
        for (ItemListener l : this.itemListeners) {
            l.itemStateChanged(event);
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] l_selection = null;
        if (this.selectedIndex >= 0) {
            l_selection = new Object[]{this.colorPalette.get(this.selectedIndex)};
        }
        return l_selection;
    }
}

