/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine.cms;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorMatchingSystem {
    public static final String APPROVE_ACTION = "approve";
    private ColorSpace cs;
    private Color referenceColor;
    private Color sampleColor;
    protected final ArrayList<ChangeListener> changeListeners;
    protected final ArrayList<ActionListener> actionListeners;
    protected final ChangeEvent defaultChangeEvent;
    protected final ActionEvent approveActionEvent;
    private boolean approved;

    public ColorMatchingSystem(ColorSpace targetColorSpace) {
        this.cs = targetColorSpace;
        this.sampleColor = null;
        this.referenceColor = null;
        this.approved = false;
        this.changeListeners = new ArrayList();
        this.defaultChangeEvent = new ChangeEvent(this);
        this.actionListeners = new ArrayList();
        this.approveActionEvent = new ActionEvent(this, 1001, APPROVE_ACTION);
    }

    public void setColorSpace(ColorSpace cs) {
        this.cs = cs;
        if (cs != null && this.referenceColor != null) {
            this.sampleColor = this.match(this.referenceColor);
            this.approved = false;
        } else {
            this.sampleColor = null;
        }
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    public void setReferenceColor(Color color) {
        this.referenceColor = color;
        this.sampleColor = this.match(color);
        this.approved = false;
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    public Color getReferenceColor() {
        return this.referenceColor;
    }

    public Color getSampleColor() {
        return this.sampleColor;
    }

    public void replaceSampleColor(Color color) {
        this.sampleColor = color;
        this.approved = false;
        this.fireChangeEvent(this.defaultChangeEvent);
    }

    protected Color match(Color color) {
        if (color == null || this.cs == null) {
            return null;
        }
        ColorSpace l_cs = color.getColorSpace();
        if (this.cs.equals(l_cs)) {
            return color;
        }
        float[] l_colorComponents = color.getColorComponents(null);
        float[] l_ciexyz = l_cs.toCIEXYZ(l_colorComponents);
        return (l_colorComponents = this.cs.fromCIEXYZ(l_ciexyz)) != null ? new Color(this.cs, l_colorComponents, 1.0f) : null;
    }

    public void approve() {
        this.approved = true;
        this.fireActionEvent(this.approveActionEvent);
    }

    public boolean isApproved() {
        return this.approved;
    }

    public boolean isArmed() {
        return this.referenceColor != null && this.sampleColor != null && this.referenceColor != this.sampleColor;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent(ChangeEvent e) {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    protected void fireActionEvent(ActionEvent e) {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(e);
        }
    }
}

