/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine;

import com.valeras.color_combine.cms.ColorMatchingSystem;
import com.valeras.color_combine.model.ColorProducer;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.color_combine.model.ColorTuner;
import com.valeras.color_combine.view.ColorPalettePreview;
import java.awt.color.ColorSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ColorCombineComponents {
    protected final HashMap<String, ColorProducer> colorSampleProducerList = new HashMap();
    protected final HashMap<String, ColorScheme> colorSchemeList = new HashMap();
    protected final ArrayList<String> colorSchemeOrderedList = new ArrayList();
    protected final ArrayList<ColorPalettePreview> colorPalettePreviews;
    protected final HashMap<String, ColorTuner> colorTunerList = new HashMap();
    protected ColorMatchingSystem colorMatchingSystem = null;
    protected ColorScheme selectedColorScheme = null;
    private ColorSpace colorSpace = null;
    private ColorSpace colorMatchingColorSpace = null;

    public ColorCombineComponents() {
        this.colorPalettePreviews = new ArrayList();
    }

    public void addColorScheme(ColorScheme colorScheme) {
        this.colorSchemeOrderedList.add(colorScheme.getName());
        this.colorSchemeList.put(colorScheme.getName(), colorScheme);
    }

    public ColorScheme getSelectedColorScheme() {
        return this.selectedColorScheme;
    }

    public ColorScheme getColorScheme(String name) {
        return this.colorSchemeList.get(name);
    }

    public List<String> getColorSchemeList() {
        return this.colorSchemeOrderedList;
    }

    public void setSelectedColorScheme(String colorSchemeName) {
        this.selectedColorScheme = this.getColorScheme(colorSchemeName);
    }

    public void addColorSampleProducer(ColorProducer colorSampler) {
        this.colorSampleProducerList.put(colorSampler.getName(), colorSampler);
    }

    public void addColorTuner(ColorTuner colorTuner) {
        this.colorTunerList.put(colorTuner.getName(), colorTuner);
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace cs) {
        this.colorSpace = cs;
    }

    public void setColorMatchingSystem(ColorMatchingSystem cms) {
        this.colorMatchingSystem = cms;
    }

    public ColorMatchingSystem getColorMatchingSystem() {
        return this.colorMatchingSystem;
    }

    public ColorSpace getColorMatchingColorSpace() {
        return this.colorMatchingColorSpace;
    }

    public void setColorMatchingColorSpace(ColorSpace cs) {
        this.colorMatchingColorSpace = cs;
        if (this.colorMatchingSystem != null) {
            this.colorMatchingSystem.setColorSpace(cs);
        }
    }

    public void addColorPalettePreview(ColorPalettePreview preview) {
        this.colorPalettePreviews.add(preview);
    }

    public void removeColorPalettePreview(ColorPalettePreview preview) {
        this.colorPalettePreviews.remove(preview);
    }
}

