/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.color_combine;

import com.valeras.color_combine.ColorCombineComponents;
import com.valeras.color_combine.cms.ColorMatchingSystem;
import com.valeras.color_combine.controller.ColorPaletteController;
import com.valeras.color_combine.controller.ColorPreviewController;
import com.valeras.color_combine.controller.ColorTunerController;
import com.valeras.color_combine.controller.SampleColorProducerController;
import com.valeras.color_combine.events.ColorProduceEvent;
import com.valeras.color_combine.events.ColorProduceListener;
import com.valeras.color_combine.model.ColorPalette;
import com.valeras.color_combine.model.ColorProducer;
import com.valeras.color_combine.model.ColorScheme;
import com.valeras.color_combine.model.ColorTuner;
import com.valeras.color_combine.view.ColorPalettePreview;
import com.valeras.color_combine.view.ColorPaletteView;
import com.valeras.color_combine.view.ColorProducerView;
import com.valeras.color_combine.view.ColorTunerView;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorCombineToolkit
extends ColorCombineComponents {
    public static final String LIST_DELIMITER = ";";
    private ColorPalette colorPalette = null;
    private ColorProducer selectedColorSampleProducer = null;
    private SampleColorProducerController colorSampleProducerController = null;
    private ColorPaletteController colorPaletteController = null;
    private final ArrayList<ColorTunerController> colorTunerControllers;
    private final ArrayList<ColorPreviewController> colorPreviewControllers = new ArrayList();
    private final ColorProduceListener colorSamplerListener;
    private final ColorProduceListener colorTunerListener;
    private final ActionListener colorMatchingListener;
    private final ItemListener colorPaletteItemListener;
    private final ChangeListener colorPaletteChangeListener;
    private final ArrayList<ChangeListener> externalColorPaletteChangeListeners;
    private final ArrayList<ChangeListener> externalColorMatchingChangeListeners;
    private final ArrayList<ItemListener> externalColorPaletteItemListeners;
    private final ChangeEvent defaultColorMatchingChangeEvent;

    protected AbstractColorCombineToolkit() {
        this.colorTunerControllers = new ArrayList();
        this.colorSamplerListener = new ColorProduceListener(){

            @Override
            public void colorProduced(ColorProduceEvent event) {
                if (AbstractColorCombineToolkit.this.colorPaletteController != null) {
                    AbstractColorCombineToolkit.this.colorPaletteController.setColor(AbstractColorCombineToolkit.this.colorPaletteController.getSelectedIndex(), event.getColor());
                }
            }
        };
        this.colorMatchingListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("approve") && AbstractColorCombineToolkit.this.colorPaletteController != null) {
                    AbstractColorCombineToolkit.this.colorPaletteController.setColor(AbstractColorCombineToolkit.this.colorPaletteController.getSelectedIndex(), AbstractColorCombineToolkit.this.colorMatchingSystem.getSampleColor());
                }
            }
        };
        this.colorTunerListener = new ColorProduceListener(){

            @Override
            public void colorProduced(ColorProduceEvent event) {
                if (AbstractColorCombineToolkit.this.colorPaletteController != null) {
                    AbstractColorCombineToolkit.this.colorPaletteController.setColor(AbstractColorCombineToolkit.this.colorPaletteController.getSelectedIndex(), event.getColor());
                }
            }
        };
        this.colorPaletteItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AbstractColorCombineToolkit.this.notifyColorPaletteItemListeners(e);
            }
        };
        this.colorPaletteChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractColorCombineToolkit.this.notifyColorPaletteChangeListeners(e);
            }
        };
        this.externalColorPaletteChangeListeners = new ArrayList();
        this.externalColorPaletteItemListeners = new ArrayList();
        this.externalColorMatchingChangeListeners = new ArrayList();
        this.defaultColorMatchingChangeEvent = new ChangeEvent(this);
    }

    protected void toolkitInit(ColorPalette colorPalette, String colorSampler, String colorScheme, String colorTuners) {
        this.colorPalette = colorPalette;
        this.setColorPaletteController((ColorPaletteController)this.attachView(this.colorPalette).getController());
        this.selectedColorSampleProducer = (ColorProducer)this.colorSampleProducerList.get(colorSampler);
        this.selectedColorScheme = (ColorScheme)this.colorSchemeList.get(colorScheme);
        this.selectedColorSampleProducer.setColorScheme(this.selectedColorScheme);
        this.setColorSampleProducerController((SampleColorProducerController)this.attachView(this.selectedColorSampleProducer).getController());
        if (colorTuners != null) {
            String[] l_modelList;
            for (String name : l_modelList = colorTuners.split(LIST_DELIMITER)) {
                this.addColorTunerController(this.attachView((ColorTuner)this.colorTunerList.get(name)).getController());
            }
        }
    }

    public abstract ColorProducerView attachView(ColorProducer var1);

    public abstract ColorPaletteView attachView(ColorPalette var1);

    public abstract ColorTunerView attachView(ColorTuner var1);

    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    public void setSelectedPaletteEntryLabel(String text) {
        this.colorPaletteController.setLabel(this.colorPaletteController.getSelectedIndex(), text);
    }

    public String getSelectedPaletteEntryLabel() {
        return this.colorPalette.getLabel(this.colorPaletteController.getSelectedIndex());
    }

    public int getSelectedPaletteEntryIndex() {
        return this.colorPaletteController.getSelectedIndex();
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
        for (ColorPalettePreview p : this.colorPalettePreviews) {
            p.setColorPalette(this.colorPalette);
        }
    }

    public void updateColorPalette(ColorPalette palette) {
        this.colorPaletteController.updateColorPalette(palette);
    }

    public void setColorPaletteSelectedEntryIndex(int index) {
        this.colorPaletteController.setSelectedIndex(index);
    }

    @Override
    public void setColorMatchingColorSpace(ColorSpace cs) {
        super.setColorMatchingColorSpace(cs);
        this.fireColorMatchingChangeEvent();
    }

    @Override
    public void setColorMatchingSystem(ColorMatchingSystem cms) {
        if (this.colorMatchingSystem != null) {
            this.colorMatchingSystem.removeActionListener(this.colorMatchingListener);
        }
        super.setColorMatchingSystem(cms);
        if (cms != null) {
            cms.addActionListener(this.colorMatchingListener);
        }
        this.fireColorMatchingChangeEvent();
    }

    public Color getSelectedColor() {
        Color l_color = null;
        int l_index = this.colorPaletteController.getSelectedIndex();
        if (l_index >= 0) {
            l_color = (Color)this.colorPalette.get(l_index);
        }
        return l_color;
    }

    public void setSelectedColor(Color color) {
        int l_index = this.colorPaletteController.getSelectedIndex();
        if (l_index != -1) {
            this.colorPaletteController.setColor(l_index, color);
        }
    }

    @Override
    public void setSelectedColorScheme(String colorSchemeName) {
        super.setSelectedColorScheme(colorSchemeName);
        this.colorSampleProducerController.setColorScheme(this.selectedColorScheme);
    }

    private void notifyColorPaletteChangeListeners(ChangeEvent event) {
        Color l_color = null;
        ColorMatchingSystem l_cms = this.getColorMatchingSystem();
        int l_index = this.colorPaletteController.getSelectedIndex();
        if (l_index >= 0) {
            l_color = (Color)this.colorPaletteController.getModel().get(l_index);
        }
        for (ColorTunerController colorTunerController : this.colorTunerControllers) {
            colorTunerController.setColor(l_color);
        }
        if (l_cms != null) {
            l_cms.setReferenceColor(l_color);
        }
        for (ColorPreviewController colorPreviewController : this.colorPreviewControllers) {
            colorPreviewController.setColor(l_color);
        }
        for (ColorPalettePreview colorPalettePreview : this.colorPalettePreviews) {
            colorPalettePreview.stateChanged(event);
        }
        for (ChangeListener changeListener : this.externalColorPaletteChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    private void notifyColorPaletteItemListeners(ItemEvent event) {
        if (event.getStateChange() == 1) {
            ColorMatchingSystem l_cms = this.getColorMatchingSystem();
            Color l_color = (Color)this.colorPaletteController.getModel().get(this.colorPaletteController.getSelectedIndex());
            for (ColorTunerController colorTunerController : this.colorTunerControllers) {
                colorTunerController.setColor(l_color);
            }
            if (l_cms != null) {
                l_cms.setReferenceColor(l_color);
            }
            for (ColorPreviewController colorPreviewController : this.colorPreviewControllers) {
                colorPreviewController.setColor(l_color);
            }
        }
        for (ItemListener l : this.colorPalettePreviews) {
            l.itemStateChanged(event);
        }
        for (ItemListener l : this.externalColorPaletteItemListeners) {
            l.itemStateChanged(event);
        }
    }

    protected void setColorSampleProducerController(SampleColorProducerController controller) {
        if (this.colorSampleProducerController != null) {
            this.colorSampleProducerController.removeColorProduceListener(this.colorSamplerListener);
        }
        this.colorSampleProducerController = controller;
        if (this.colorSampleProducerController != null) {
            this.colorSampleProducerController.addColorProduceListener(this.colorSamplerListener);
        }
    }

    protected void setColorPaletteController(ColorPaletteController controller) {
        if (this.colorPaletteController != null) {
            this.colorPaletteController.removeItemListener(this.colorPaletteItemListener);
            this.colorPaletteController.removeChangeListener(this.colorPaletteChangeListener);
        }
        this.colorPaletteController = controller;
        if (this.colorPaletteController != null) {
            this.colorPaletteController.addItemListener(this.colorPaletteItemListener);
            this.colorPaletteController.addChangeListener(this.colorPaletteChangeListener);
        }
    }

    protected void addColorPreviewController(ColorPreviewController model) {
        this.colorPreviewControllers.add(model);
    }

    protected void removeColorPreviewController(ColorPreviewController model) {
        this.colorPreviewControllers.remove(model);
    }

    protected void addColorTunerController(ColorTunerController controller) {
        this.colorTunerControllers.add(controller);
        controller.addColorProduceListener(this.colorTunerListener);
    }

    protected void removeColorTunerController(ColorTunerController controller) {
        this.colorTunerControllers.remove(controller);
        controller.removeColorProduceListener(this.colorTunerListener);
    }

    public void addColorPaletteChangeListener(ChangeListener listener) {
        this.externalColorPaletteChangeListeners.add(listener);
    }

    public void removeColorPaletteChangeListener(ChangeListener listener) {
        this.externalColorPaletteChangeListeners.remove(listener);
    }

    public void addColorPaletteItemListener(ItemListener listener) {
        this.externalColorPaletteItemListeners.add(listener);
    }

    public void removeColorPaletteItemListener(ItemListener listener) {
        this.externalColorPaletteItemListeners.remove(listener);
    }

    protected void fireColorMatchingChangeEvent() {
        for (ChangeListener l : this.externalColorMatchingChangeListeners) {
            l.stateChanged(this.defaultColorMatchingChangeEvent);
        }
    }

    public void addColorMatchingChangeListener(ChangeListener listener) {
        this.externalColorMatchingChangeListeners.add(listener);
    }

    public void removeColorMatchingChangeListener(ChangeListener listener) {
        this.externalColorMatchingChangeListeners.remove(listener);
    }
}

