/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.effects2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class DropShadowIcon
implements Icon {
    private static final int OVERSAMPLE = 6;
    private static final Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final BufferedImage image;
    private final AffineTransform tx;

    private DropShadowIcon(BufferedImage image, AffineTransform tx) {
        this.image = image;
        this.tx = (AffineTransform)tx.clone();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AffineTransform l_tx = AffineTransform.getTranslateInstance(this.tx.getTranslateX() + (double)x, this.tx.getTranslateY() + (double)y);
        ((Graphics2D)g).drawImage(this.image, l_tx, null);
    }

    public int getIconWidth() {
        return this.image.getWidth();
    }

    public int getIconHeight() {
        return this.image.getHeight();
    }

    private static DropShadowIcon createDropShadowIcon(Shape shape, Point2D tx, float opacity, boolean vergeOnly, float outlineWidth) {
        Color l_color;
        Shape l_stamp;
        DropShadowIcon l_icon = null;
        int l_dx = (int)tx.getX();
        int l_dy = (int)tx.getY();
        int l_samples = Math.max(Math.abs(l_dx), Math.abs(l_dy)) * 6;
        float l_sx = (float)(tx.getX() / (double)l_samples);
        float l_sy = (float)(tx.getY() / (double)l_samples);
        int l_x0 = l_dx >= 0 ? 0 : -l_dx;
        int l_y0 = l_dy >= 0 ? 0 : -l_dy;
        Rectangle l_bounds = shape.getBounds();
        int l_width = (int)((RectangularShape)l_bounds).getWidth();
        int l_height = (int)((RectangularShape)l_bounds).getHeight();
        Shape l_shape = AffineTransform.getTranslateInstance(-((RectangularShape)l_bounds).getX(), -((RectangularShape)l_bounds).getY()).createTransformedShape(shape);
        BufferedImage l_image = new BufferedImage(l_width + Math.abs(l_dx), l_height + Math.abs(l_dy), 2);
        Graphics2D l_gr = l_image.createGraphics();
        l_gr.setColor(transparentColor);
        l_gr.fillRect(0, 0, l_image.getWidth(), l_image.getHeight());
        Composite l_composite = l_gr.getComposite();
        if (l_composite instanceof AlphaComposite) {
            l_gr.setComposite(((AlphaComposite)l_composite).derive(2));
        }
        float l_alphaStep = opacity / (float)(l_samples - 1);
        for (int i = l_samples - 1; i > 0; --i) {
            AffineTransform l_tx = AffineTransform.getTranslateInstance((float)l_x0 + (float)i * l_sx, (float)l_y0 + (float)i * l_sy);
            l_stamp = l_tx.createTransformedShape(l_shape);
            l_color = new Color(0.0f, 0.0f, 0.0f, opacity - (float)i * l_alphaStep);
            l_gr.setColor(l_color);
            l_gr.draw(l_stamp);
        }
        l_stamp = AffineTransform.getTranslateInstance(l_x0, l_y0).createTransformedShape(l_shape);
        l_color = vergeOnly ? transparentColor : new Color(0.0f, 0.0f, 0.0f, opacity);
        l_gr.setPaint(l_color);
        l_gr.fill(l_stamp);
        if (outlineWidth > 1.0f) {
            BasicStroke l_stroke = new BasicStroke(outlineWidth);
            l_gr.setStroke(l_stroke);
        }
        l_gr.draw(l_stamp);
        l_icon = new DropShadowIcon(l_image, AffineTransform.getTranslateInstance(-l_x0, -l_y0));
        return l_icon;
    }

    public static DropShadowIcon createDropShadow(Shape shape, Point2D direction, float opacity) {
        return DropShadowIcon.createDropShadowIcon(shape, direction, opacity, false, 1.0f);
    }

    public static DropShadowIcon createVergeShadow(Shape shape, Point2D direction, float opacity, float outlineWidth) {
        return DropShadowIcon.createDropShadowIcon(shape, direction, opacity, true, outlineWidth);
    }
}

