/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.html_colors;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.ColorChartEntry;
import com.valeras.color_chart.io.CLUECSVParser;
import com.valeras.color_chart.io.CLUEFactory;
import com.valeras.color_chart.io.CLUEParser;
import com.valeras.color_chart.io.CLUTReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTMLColors
extends ColorChart {
    public static final String NAME = "CS_W3C_HTMLColors";
    public static final String DISPLAY_NAME = "HTML Colors";
    public static final String DESCRIPTION = "W3C HTML Colors";
    private static final String CS_PATH_PREFIX = "resources/";
    private static HTMLColors instance;

    public static HTMLColors getInstance() {
        if (instance == null) {
            instance = new HTMLColors();
        }
        return instance;
    }

    protected HTMLColors() {
        super(NAME);
        InputStream l_stream = null;
        String l_path = "resources/html_colors.csv";
        this.setEntryIdentifier(ColorChart.EntryIdentifier.Name);
        l_stream = HTMLColors.class.getResourceAsStream("resources/html_colors.csv");
        CLUECSVParser l_parser = new CLUECSVParser();
        l_parser.addColumn(0, "color_chart_entry.name", "format.string");
        l_parser.addColumn(2, "color_chart_entry.value", "format.string");
        l_parser.addColumn(3, "color_chart_entry.color", "format.rgb_tuple");
        CLUEFactory l_factory = new CLUEFactory(){

            public ColorChartEntry create() {
                return new ColorChartEntry((ColorChart)HTMLColors.this);
            }
        };
        CLUTReader l_reader = new CLUTReader((CLUEParser)l_parser, l_factory);
        try {
            Collection l_entries = l_reader.read(l_stream, this.clut);
            this.entries.addAll(l_entries);
        }
        catch (IOException ex) {
            Logger.getLogger(HTMLColors.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            Logger.getLogger(HTMLColors.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

