/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.app_skeleton;

import com.valeras.app_skeleton.AbstractFeature;
import java.text.MessageFormat;

public abstract class Application {
    private static final String STR_ALREADY_RUNNING = "You cannot start executing this application because another instance of {0} is currently running.";
    private static Application instance = null;
    protected final String name;
    protected final AbstractFeature features;

    protected Application(String name) {
        this.name = name;
        this.features = new ApplicationFeatures();
    }

    public final String getName() {
        return this.name;
    }

    protected final void addFeature(AbstractFeature feature) {
        this.features.add(feature);
    }

    public AbstractFeature getFeature(String name) {
        return this.features.getFeature(name);
    }

    public AbstractFeature getFeature(int id) {
        return this.features.getFeature(id);
    }

    public static Application getInstance() {
        return instance;
    }

    public static void execute(Application app, String[] args) {
        if (instance != null) {
            throw new RuntimeException(MessageFormat.format(STR_ALREADY_RUNNING, instance.toString()));
        }
        instance = app;
        app.applicationInit();
        app.applicationRun(args);
    }

    public static void exit(boolean displayAlerts) {
        if (instance.canQuit(displayAlerts)) {
            instance.applicationQuit();
            instance = null;
        }
    }

    public abstract String getVersion();

    protected void applicationInit() {
        this.features.initialize(this);
    }

    protected abstract void applicationRun(String[] var1);

    protected void applicationQuit() {
        this.features.dispose();
        System.exit(0);
    }

    protected abstract boolean canQuit(boolean var1);

    private class ApplicationFeatures
    extends AbstractFeature {
        ApplicationFeatures() {
            super(-1, "application_features");
        }

        @Override
        protected void featureInit(Application app) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

