/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.app_skeleton;

import com.valeras.app_skeleton.Application;
import java.util.ArrayList;
import java.util.Locale;

public abstract class AbstractFeature {
    public static final int DEFAULT_FEATURE_ID = 0;
    protected final int id;
    protected final String name;
    protected final ArrayList<AbstractFeature> features;
    private boolean initialized;
    private Object featuredObject;

    protected AbstractFeature(int id, String name) {
        this.id = id;
        this.name = name;
        this.features = new ArrayList();
        this.featuredObject = null;
        this.initialized = false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    public final void add(AbstractFeature feature) {
        this.features.add(feature);
    }

    public AbstractFeature getFeature(String name) {
        AbstractFeature l_feature = null;
        for (AbstractFeature f : this.features) {
            if (name.equals(f.name)) {
                l_feature = f;
                break;
            }
            if (!f.containsFeature(name)) continue;
            l_feature = f.getFeature(name);
        }
        return l_feature;
    }

    public AbstractFeature getFeature(int id) {
        AbstractFeature l_feature = null;
        for (AbstractFeature f : this.features) {
            if (id == f.id) {
                l_feature = f;
                break;
            }
            if (!f.containsFeature(id)) continue;
            l_feature = f.getFeature(id);
        }
        return l_feature;
    }

    public final void initialize(Application app) {
        this.featureInit(app);
        for (AbstractFeature f : this.features) {
            f.initialize(app);
        }
        this.initialized = true;
    }

    protected abstract void featureInit(Application var1);

    public final void dispose() {
        for (AbstractFeature f : this.features) {
            f.dispose();
        }
        this.featureDispose();
        this.initialized = false;
    }

    protected void featureDispose() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public abstract boolean isEnabled();

    public boolean containsFeature(String name) {
        for (AbstractFeature f : this.features) {
            if (!name.equals(f.name) && !f.containsFeature(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsFeature(int id) {
        for (AbstractFeature f : this.features) {
            if (id != f.id && !f.containsFeature(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isFeatureEnabled(String name) {
        for (AbstractFeature f : this.features) {
            if (name.equals(f.name)) {
                return f.isEnabled();
            }
            if (!f.containsFeature(name)) continue;
            return f.isFeatureEnabled(name);
        }
        return false;
    }

    protected void setFeaturedObject(Object featuredObject) {
        this.featuredObject = featuredObject;
    }

    public Object getFeaturedObject() {
        return this.featuredObject;
    }
}

