/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.cns.color_wheel;

import com.valeras.cns.ColorNamingSystem;
import com.valeras.cns.color_wheel.RYBColors;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorWheelCNS
implements ColorNamingSystem {
    private static final String STRING_TABLE_BUNDLE = "com.valeras.cns.color_wheel.resources.cwcns";
    private static final String NAME = "cns.color_wheel";
    private static final String COLOR_PRIMARY_BLUE = "color.blue";
    private static final String COLOR_PRIMARY_RED = "color.red";
    private static final String COLOR_PRIMARY_YELLOW = "color.yellow";
    private static final String COLOR_SECONDARY_GREEN = "color.green";
    private static final String COLOR_SECONDARY_ORANGE = "color.orange";
    private static final String COLOR_SECONDARY_VIOLET = "color.violet";
    private static final String COLOR_TERTIARY_BLUE_GREEN = "color.blue-green";
    private static final String COLOR_TERTIARY_BLUE_VIOLET = "color.blue-violet";
    private static final String COLOR_TERTIARY_RED_ORANGE = "color.red-orange";
    private static final String COLOR_TERTIARY_RED_VIOLET = "color.red-violet";
    private static final String COLOR_TERTIARY_YELLOW_GREEN = "color.yellow-green";
    private static final String COLOR_TERTIARY_YELLOW_ORANGE = "color.yellow-orange";
    private static final String VALUE_BLACK = "color.value.black";
    private static final String VALUE_VERY_DARK = "color.value.very_dark";
    private static final String VALUE_DARK = "color.value.dark";
    private static final String VALUE_MEDIUM = "color.value.medium";
    private static final String VALUE_LIGHT = "color.value.light";
    private static final String VALUE_VERY_LIGHT = "color.value.very_light";
    private static final String VALUE_WHITE = "color.value.white";
    private static final String GRAY_NAME_BLACK = "color.gray_name.black";
    private static final String GRAY_NAME_GRAY = "color.gray_name.gray";
    private static final String GRAY_NAME_WHITE = "color.gray_name.white";
    private static final String TINT_WHITISH = "color.tint.whitish";
    private static final String TINT_PALE = "color.tint.pale";
    private static final String TINT_BRILLIANT = "color.tint.brilliant";
    private static final String TINT_VIVID = "color.tint.vivid";
    private static final String SHADE_BLACKISH = "color.shade.blackish";
    private static final String SHADE_DIM = "color.shade.dim";
    private static final String SHADE_DEEP = "color.shade.deep";
    private static final String SHADE_VIVID = "color.shade.vivid";
    private static final String SATURATION_GRAYISH = "color.saturation.grayish";
    private static final String SATURATION_MODERATE = "color.saturation.moderate";
    private static final String SATURATION_STRONG = "color.saturation.strong";
    private static final String SATURATION_VIVID = "color.saturation.vivid";
    private final float[] hues = new float[12];
    private final String[] hueNames;
    private final float[] values = new float[]{0.16f, 0.333f, 0.5f, 0.667f, 0.833f};
    private final String[] valueNames = new String[]{"color.value.very_dark", "color.value.dark", "color.value.medium", "color.value.light", "color.value.very_light"};
    private final float[] values2 = new float[]{0.0f, 0.167f, 0.333f, 0.5f, 0.667f, 0.833f, 1.0f};
    private final String[] valueNames2 = new String[]{"color.value.black", "color.value.very_dark", "color.value.dark", "color.value.medium", "color.value.light", "color.value.very_light", "color.value.white"};
    private final float[] whiteness = new float[]{0.25f, 0.5f, 0.75f, 1.0f};
    private final String[] whitenessNames = new String[]{"color.tint.whitish", "color.tint.pale", "color.tint.brilliant", "color.tint.vivid"};
    private final float[] blackness = new float[]{0.25f, 0.5f, 0.75f, 1.0f};
    private final String[] blacknessNames = new String[]{"color.shade.blackish", "color.shade.dim", "color.shade.deep", "color.shade.vivid"};
    private final float[] saturations = new float[]{0.25f, 0.5f, 0.75f, 1.0f};
    private final String[] saturationNames = new String[]{"color.saturation.grayish", "color.saturation.moderate", "color.saturation.strong", "color.saturation.vivid"};

    public ColorWheelCNS() {
        this.hues[0] = ColorWheelCNS.getHue(RYBColors.PRIMARY_RED);
        this.hues[1] = ColorWheelCNS.getHue(RYBColors.TERTIARY_RED_ORANGE);
        this.hues[2] = ColorWheelCNS.getHue(RYBColors.SECONDARY_ORANGE);
        this.hues[3] = ColorWheelCNS.getHue(RYBColors.TERTIARY_YELLOW_ORANGE);
        this.hues[4] = ColorWheelCNS.getHue(RYBColors.PRIMARY_YELLOW);
        this.hues[5] = ColorWheelCNS.getHue(RYBColors.TERTIARY_YELLOW_GREEN);
        this.hues[6] = ColorWheelCNS.getHue(RYBColors.SECONDARY_GREEN);
        this.hues[7] = ColorWheelCNS.getHue(RYBColors.TERTIARY_BLUE_GREEN);
        this.hues[8] = ColorWheelCNS.getHue(RYBColors.PRIMARY_BLUE);
        this.hues[9] = ColorWheelCNS.getHue(RYBColors.TERTIARY_BLUE_VIOLET);
        this.hues[10] = ColorWheelCNS.getHue(RYBColors.SECONDARY_VIOLET);
        this.hues[11] = ColorWheelCNS.getHue(RYBColors.TERTIARY_RED_VIOLET);
        this.hueNames = new String[]{COLOR_PRIMARY_RED, COLOR_TERTIARY_RED_ORANGE, COLOR_SECONDARY_ORANGE, COLOR_TERTIARY_YELLOW_ORANGE, COLOR_PRIMARY_YELLOW, COLOR_TERTIARY_YELLOW_GREEN, COLOR_SECONDARY_GREEN, COLOR_TERTIARY_BLUE_GREEN, COLOR_PRIMARY_BLUE, COLOR_TERTIARY_BLUE_VIOLET, COLOR_SECONDARY_VIOLET, COLOR_TERTIARY_RED_VIOLET};
    }

    private static float getHue(Color color) {
        float[] l_hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return l_hsb[0];
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDisplayName(Locale locale) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int indexOf(float[] values, float key, boolean exactLimits, boolean wrap) {
        float WRAP_MAX = 1.0f;
        float WRAP_MIN = 0.0f;
        int l_index = Arrays.binarySearch(values, key);
        if (l_index < 0) {
            int l_index2;
            l_index = -(l_index + 1);
            if (exactLimits) {
                if (l_index == 1) {
                    return 1;
                }
                if (l_index == values.length - 1) {
                    return l_index - 1;
                }
            }
            if ((l_index2 = l_index - 1) < 0) {
                if (wrap) {
                    l_index2 = values.length - 1;
                    float l_d = Math.abs(key - values[l_index]);
                    float l_d2 = Math.abs(key - 0.0f);
                    if (l_d2 < l_d) {
                        l_index = l_index2;
                    }
                }
            } else if (l_index >= values.length) {
                if (wrap) {
                    l_index = 0;
                    float l_d = Math.abs(1.0f - key + (values[0] - 0.0f));
                    float l_d2 = Math.abs(key - values[l_index2]);
                    if (l_d2 < l_d) {
                        l_index = l_index2;
                    }
                } else {
                    l_index = values.length - 1;
                }
            } else {
                float l_d = Math.abs(key - values[l_index]);
                float l_d2 = Math.abs(key - values[l_index2]);
                if (l_d2 < l_d) {
                    l_index = l_index2;
                }
            }
        }
        return l_index;
    }

    private String nameOf(Color color, Locale locale) {
        String l_name = null;
        float[] l_hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float h = l_hsb[0];
        float s = l_hsb[1];
        float v = l_hsb[2];
        if (s == 0.0f) {
            int l_index = this.indexOf(this.values2, v, true, false);
            String l_value = this.valueNames2[l_index];
            l_name = l_value.equals(VALUE_BLACK) ? this.getString(GRAY_NAME_BLACK, locale) : (l_value.equals(VALUE_WHITE) ? this.getString(GRAY_NAME_WHITE, locale) : this.getString(l_value, locale) + " " + this.getString(GRAY_NAME_GRAY, locale));
            return l_name.toLowerCase();
        }
        int l_index = this.indexOf(this.hues, h, false, true);
        String l_hue = this.hueNames[l_index];
        if (v == 1.0f) {
            l_index = this.indexOf(this.whiteness, s, true, false);
            String l_value = this.whitenessNames[l_index];
            l_name = this.getString(l_value, locale) + " " + this.getString(l_hue, locale);
            return l_name.toLowerCase();
        }
        if (s == 1.0f) {
            l_index = this.indexOf(this.blackness, v, false, false);
            String l_value = this.blacknessNames[l_index];
            l_name = this.getString(l_value, locale) + " " + this.getString(l_hue, locale);
            return l_name.toLowerCase();
        }
        l_index = this.indexOf(this.saturations, s, false, false);
        String l_saturation = this.saturationNames[l_index];
        l_index = this.indexOf(this.values, v, false, false);
        String l_value = this.valueNames[l_index];
        l_name = this.getString(l_value, locale) + " " + this.getString(l_saturation, locale) + " " + this.getString(l_hue, locale);
        return l_name.trim().toLowerCase();
    }

    protected String getString(String key, Locale locale) {
        String l_text;
        ResourceBundle l_bundle;
        try {
            l_bundle = ResourceBundle.getBundle(STRING_TABLE_BUNDLE, locale);
        }
        catch (RuntimeException ex) {
            Logger.getLogger(ColorWheelCNS.class.getName()).log(Level.WARNING, null, ex);
            return key;
        }
        try {
            l_text = l_bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(ColorWheelCNS.class.getName()).log(Level.WARNING, null, ex);
            return key;
        }
        return l_text;
    }

    @Override
    public String displayNameOf(Color color) {
        return this.nameOf(color, Locale.getDefault());
    }

    @Override
    public String displayNameOf(Color color, Locale locale) {
        return this.nameOf(color, locale);
    }
}

