/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.property_storage;

import com.valeras.copy_protection.property_storage.AbstractPropertyStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.util.Properties;
import java.util.prefs.BackingStoreException;

public class PropertiesBasedStorage
extends AbstractPropertyStorage
implements Flushable {
    public static final String NAME = "cp.component.property_storage.properties_based";
    public static final String COMMENT = "DO NOT MODIFY THIS FILE!";
    protected final Properties properties = new Properties();
    protected final File file;

    public PropertiesBasedStorage(File file, String secretKey) {
        super(true, secretKey);
        this.file = file;
    }

    @Override
    public void connectBackingStore() throws BackingStoreException {
        FileInputStream l_is = null;
        try {
            l_is = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new BackingStoreException(ex);
        }
        if (l_is != null) {
            try {
                this.properties.load(l_is);
            }
            catch (IOException ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        File l_dir = this.file.getParentFile();
        if (!l_dir.exists()) {
            l_dir.mkdirs();
        }
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        FileOutputStream l_os = new FileOutputStream(this.file);
        this.properties.store(l_os, COMMENT);
    }

    @Override
    public boolean propertyExists(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String propertyGet(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String propertyGet(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Object propertySet(String key, String value) {
        Object l_oldValue = null;
        if (value != null) {
            l_oldValue = this.properties.setProperty(key, value);
        } else if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        return l_oldValue;
    }
}

