/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.property_storage;

import com.valeras.copy_protection.ByteSeries;
import com.valeras.copy_protection.PropertyContainer;
import com.valeras.copy_protection.PropertyStorage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public abstract class AbstractPropertyStorage
implements PropertyStorage,
PropertyChangeListener {
    private static final String MSG_NO_SECRETTEXT = "Attribute secretKey required to secure the storage.";
    private static final String MSG_SECURITY_BREACHED = "Failed to confirm storage security.";
    private static final String MSG_SECURITY_WRONG_SECRET_KEY = "Wrong secret key.";
    private static final String MSG_SECURITY_NO_ATTRIBUTE = "Security attribute is absent: {0}";
    private static final String MSG_UPDATING_FAILED_STORAGE = "Updating storage while in the failed state.";
    private static final String MSG_UPDATING_DISABLED_STORAGE = "Attempt to update disabled storage.";
    private static final String SECURITY_KEYVALUE = "security.key";
    private static final String SECURITY_CHECKSUM = "security.checksum";
    private static final String SECURITY_ATTRIBUTES = "security.attributes";
    private static final String DEFAULT_HMAC_CHARSET = "UTF-8";
    private static final String KEY_LIST_DELIMITER = ",";
    private boolean changed;
    private MessageDigest messageDigest;
    private Charset charset;
    protected final ArrayList<PropertyContainer> containers;
    private final boolean secure;
    private final String secretKey;
    private boolean enabled = true;
    private boolean failed = false;
    private boolean securityBreached = false;
    private Throwable failCause = null;

    protected AbstractPropertyStorage(boolean secure, String secretKey) {
        this.secure = secure;
        this.secretKey = secretKey;
        this.containers = new ArrayList();
        this.changed = false;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            this.messageDigest = null;
            Logger.getLogger(AbstractPropertyStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.charset = Charset.forName(DEFAULT_HMAC_CHARSET);
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void connectBackingStore() throws BackingStoreException;

    @Override
    public final void storageInit(Collection<?> containers) throws BackingStoreException {
        Iterator<?> l_it = containers.iterator();
        this.containers.clear();
        while (l_it.hasNext()) {
            PropertyContainer c = (PropertyContainer)l_it.next();
            this.containers.add(c);
            c.addPropertyChangeListener(this);
        }
        try {
            this.connectBackingStore();
        }
        catch (BackingStoreException ex) {
            this.failed = true;
            this.failCause = ex;
            throw ex;
        }
        if (this.secure) {
            try {
                this.checkSecurity();
            }
            catch (GeneralSecurityException ex) {
                this.securityBreached = true;
                this.failed = true;
                this.failCause = ex;
            }
        }
    }

    @Override
    public Throwable getFailCause() {
        return this.failCause;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void setFailed(boolean flag) {
        this.failed = flag;
    }

    @Override
    public boolean isSecurityFailed() {
        return this.securityBreached;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean flag) {
        this.changed = flag;
    }

    private String keyOf(PropertyContainer container, String property) {
        return container.getContainerName() + "." + property;
    }

    protected abstract boolean propertyExists(String var1);

    protected abstract String propertyGet(String var1);

    protected abstract String propertyGet(String var1, String var2);

    protected abstract Object propertySet(String var1, String var2);

    @Override
    public void fetch() {
        for (PropertyContainer c : this.containers) {
            Enumeration<String> l_propertyNames = c.propertyNames();
            while (l_propertyNames != null && l_propertyNames.hasMoreElements()) {
                String l_name = l_propertyNames.nextElement();
                String l_key = this.keyOf(c, l_name);
                if (!this.propertyExists(l_key)) continue;
                String l_value = this.propertyGet(l_key);
                c.setProperty(l_name, l_value);
            }
        }
        this.setChanged(false);
    }

    @Override
    public void update() throws GeneralSecurityException {
        if (!this.enabled) {
            throw new GeneralSecurityException(MSG_UPDATING_DISABLED_STORAGE);
        }
        if (this.failed) {
            throw new GeneralSecurityException(MSG_UPDATING_FAILED_STORAGE);
        }
        for (PropertyContainer c : this.containers) {
            Enumeration<String> l_propertyNames = c.propertyNames();
            while (l_propertyNames != null && l_propertyNames.hasMoreElements()) {
                String l_name = l_propertyNames.nextElement();
                String l_key = this.keyOf(c, l_name);
                String l_value = c.getProperty(l_name);
                this.propertySet(l_key, l_value);
            }
        }
        if (this.secure) {
            this.secure();
        }
        if (this instanceof Flushable) {
            try {
                ((Flushable)((Object)this)).flush();
            }
            catch (IOException ex) {
                Logger.getLogger(AbstractPropertyStorage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.setChanged(false);
    }

    protected void secure() {
        ArrayList<String> l_keys = new ArrayList<String>();
        String l_message = "";
        String l_attributes = "";
        for (PropertyContainer c : this.containers) {
            Enumeration<String> l_properties = c.propertyNames();
            while (l_properties.hasMoreElements()) {
                l_keys.add(this.keyOf(c, l_properties.nextElement()));
            }
        }
        for (int i = 0; i < l_keys.size(); ++i) {
            l_attributes = l_attributes + (i > 0 ? KEY_LIST_DELIMITER : "") + l_keys.get(i);
        }
        l_message = this.messageFor(l_keys);
        if (this.secretKey == null) {
            Logger.getLogger(AbstractPropertyStorage.class.getName()).log(Level.SEVERE, MSG_NO_SECRETTEXT);
        }
        l_message = l_message + this.secretKey;
        this.propertySet(SECURITY_KEYVALUE, ByteSeries.toString(this.messageDigest.digest(this.secretKey.getBytes(this.charset))));
        this.propertySet(SECURITY_ATTRIBUTES, l_attributes);
        this.propertySet(SECURITY_CHECKSUM, ByteSeries.toString(this.messageDigest.digest(l_message.getBytes(this.charset))));
    }

    private String messageFor(ArrayList<String> keys) {
        String l_message = "";
        for (int i = 0; i < keys.size(); ++i) {
            l_message = l_message + this.valueSafe(this.propertyGet(keys.get(i)));
        }
        return l_message;
    }

    protected void checkSecurity() throws GeneralSecurityException {
        byte[] l_messageDigest;
        String l_value;
        ArrayList<String> l_keys = new ArrayList<String>();
        String l_keyList = this.propertyGet(SECURITY_ATTRIBUTES);
        if (l_keyList == null) {
            throw new GeneralSecurityException(MessageFormat.format(MSG_SECURITY_NO_ATTRIBUTE, SECURITY_ATTRIBUTES));
        }
        StringTokenizer l_tokenizer = new StringTokenizer(l_keyList, KEY_LIST_DELIMITER);
        while (l_tokenizer.hasMoreTokens()) {
            l_keys.add(l_tokenizer.nextToken());
        }
        String l_message = this.messageFor(l_keys);
        l_message = l_message + this.secretKey;
        byte[] l_bytes = this.messageDigest.digest(l_message.getBytes(this.charset));
        try {
            l_value = this.propertyGet(SECURITY_CHECKSUM);
            if (l_value == null) {
                throw new GeneralSecurityException(MessageFormat.format(MSG_SECURITY_NO_ATTRIBUTE, SECURITY_CHECKSUM));
            }
            l_messageDigest = ByteSeries.parse(l_value);
        }
        catch (ParseException ex) {
            throw new GeneralSecurityException(ex);
        }
        if (!Arrays.equals(l_bytes, l_messageDigest)) {
            throw new GeneralSecurityException(MSG_SECURITY_BREACHED);
        }
        try {
            l_value = this.propertyGet(SECURITY_KEYVALUE);
            if (l_value == null) {
                throw new GeneralSecurityException(MessageFormat.format(MSG_SECURITY_NO_ATTRIBUTE, SECURITY_KEYVALUE));
            }
            l_messageDigest = ByteSeries.parse(l_value);
        }
        catch (ParseException ex) {
            throw new GeneralSecurityException(ex);
        }
        l_bytes = this.messageDigest.digest(this.secretKey.getBytes(this.charset));
        if (!Arrays.equals(l_bytes, l_messageDigest)) {
            throw new GeneralSecurityException(MSG_SECURITY_WRONG_SECRET_KEY);
        }
    }

    private String valueSafe(String str) {
        return str != null ? str : "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setChanged(true);
    }
}

