/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.product_key.sample_format;

import com.valeras.copy_protection.ByteSeries;
import com.valeras.copy_protection.product_key.ProductKeyFormat;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class ProductKeyFormatS0
extends ProductKeyFormat {
    public static final String PARAM_APP_ID = "param.application.id";
    public static final String PARAM_APP_VERSION = "param.application.version";
    public static final String PARAM_APP_FEATURE = "param.application.feature";
    public static final String PARAM_ACTION = "param.action";
    public static final String PARAM_MACHINE_UID = "param.machine_uid";
    public static final String PARAM_USER_UID = "param.user_uid";
    public static final String PARAM_KEY_EXPIRATION_DATE = "param.key.expiration_date";
    private static final String NAME = "S0";
    private static final String SIGNATURE = "S0";
    private static final String SAMPLE_FORMAT = "XXXX-XXXX-XXXX-XXXX-XXXX-XXXX-XXXXXXXX";
    private MessageDigest messageDigest;
    private Charset charset;

    public ProductKeyFormatS0(MessageDigest messageDigest, Charset charset) {
        super("S0");
        this.messageDigest = messageDigest;
        this.charset = charset;
    }

    @Override
    public List<byte[]> format(ProductKeyParams params) {
        ByteSeries l_series = new ByteSeries();
        l_series.add("S0".getBytes(this.charset));
        l_series.add(this.packParam(PARAM_APP_ID, params));
        l_series.add(this.packParam(PARAM_APP_VERSION, params));
        l_series.add(this.packParam(PARAM_APP_FEATURE, params));
        l_series.add(this.packParam(PARAM_ACTION, params));
        l_series.add(this.packParam(PARAM_USER_UID, params));
        l_series.add(this.packParam(PARAM_KEY_EXPIRATION_DATE, params));
        return l_series;
    }

    @Override
    protected byte[] packParam(String param, Object value) {
        byte[] l_bytes = null;
        if (param.equals(PARAM_APP_ID)) {
            l_bytes = ByteSeries.getBytes((Integer)value, 2);
        } else if (param.equals(PARAM_APP_VERSION)) {
            l_bytes = this.packVersion((String)value);
        } else if (param.equals(PARAM_APP_FEATURE)) {
            l_bytes = ByteSeries.getBytes((Integer)value, 2);
        } else if (param.equals(PARAM_ACTION)) {
            l_bytes = ByteSeries.getBytes((Integer)value, 2);
        } else if (param.equals(PARAM_USER_UID)) {
            l_bytes = ((String)value).getBytes(this.charset);
            byte[] l_digest = this.messageDigest.digest(l_bytes);
            int l_hashCode = ByteSeries.hashCode(l_digest);
            l_bytes = ByteSeries.getBytes(l_hashCode, 2);
        } else if (param.equals(PARAM_KEY_EXPIRATION_DATE)) {
            l_bytes = this.packDate((Date)value);
        }
        return l_bytes;
    }

    @Override
    public ProductKeyParams parse(List<byte[]> series, ProductKeyParams params) throws ParseException {
        ProductKeyParams l_params = params != null ? params : new ProductKeyParams();
        String l_text = new String(series.get(0), this.charset);
        if (!l_text.equalsIgnoreCase("S0")) {
            throw new ParseException(l_text, 0);
        }
        this.restoreParam(PARAM_APP_ID, series.get(1), l_params);
        this.restoreParam(PARAM_APP_VERSION, series.get(2), l_params);
        this.restoreParam(PARAM_APP_FEATURE, series.get(3), l_params);
        this.restoreParam(PARAM_ACTION, series.get(4), l_params);
        this.restoreParam(PARAM_USER_UID, series.get(5), l_params);
        this.restoreParam(PARAM_KEY_EXPIRATION_DATE, series.get(6), l_params);
        return l_params;
    }

    @Override
    protected Object restoreParam(String param, byte[] bytes) throws ParseException {
        Object l_value = null;
        if (param.equals(PARAM_APP_ID)) {
            l_value = new Integer(ByteSeries.parseInt(bytes));
        } else if (param.equals(PARAM_APP_VERSION)) {
            l_value = this.restoreVersion(bytes);
        } else if (param.equals(PARAM_APP_FEATURE)) {
            l_value = new Integer(ByteSeries.parseInt(bytes));
        } else if (param.equals(PARAM_ACTION)) {
            l_value = new Integer(ByteSeries.parseInt(bytes));
        } else if (param.equals(PARAM_USER_UID)) {
            l_value = new Integer(ByteSeries.parseInt(bytes));
        } else if (param.equals(PARAM_KEY_EXPIRATION_DATE)) {
            l_value = this.restoreDate(bytes);
        }
        return l_value;
    }

    @Override
    public String getFormatSample() {
        return SAMPLE_FORMAT;
    }
}

