/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.product_key;

import com.valeras.copy_protection.ByteSeries;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public abstract class ProductKeyFormat {
    private static final HashMap<String, ProductKeyFormat> formatMap = new HashMap();
    private final String name;

    protected ProductKeyFormat(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract List<byte[]> format(ProductKeyParams var1);

    public abstract ProductKeyParams parse(List<byte[]> var1, ProductKeyParams var2) throws ParseException;

    protected final byte[] packParam(String param, ProductKeyParams params) {
        return this.packParam(param, params.get(param));
    }

    protected abstract byte[] packParam(String var1, Object var2);

    protected final void restoreParam(String name, byte[] bytes, ProductKeyParams params) throws ParseException {
        params.put(name, this.restoreParam(name, bytes));
    }

    protected abstract Object restoreParam(String var1, byte[] var2) throws ParseException;

    protected byte[] packDate(Date date) {
        Calendar l_calendar = Calendar.getInstance();
        byte[] l_bytes = new byte[4];
        l_calendar.setTime(date);
        int l_year = l_calendar.get(1);
        int l_month = l_calendar.get(2) + 1;
        int l_date = l_calendar.get(5);
        l_bytes[0] = (byte)(l_year >> 8 & 0xFF);
        l_bytes[1] = (byte)(l_year & 0xFF);
        l_bytes[2] = (byte)l_month;
        l_bytes[3] = (byte)l_date;
        return l_bytes;
    }

    protected Date restoreDate(byte[] bytes) {
        Calendar l_calendar = Calendar.getInstance();
        int l_year = ByteSeries.parseInt(bytes, 0, 2);
        int l_month = ByteSeries.parseInt(bytes, 2, 1);
        int l_date = ByteSeries.parseInt(bytes, 3, 1);
        l_calendar.set(l_year, l_month - 1, l_date);
        return l_calendar.getTime();
    }

    protected byte[] packVersion(String version) {
        byte[] l_bytes;
        ByteBuffer l_buffer = ByteBuffer.allocate(16);
        StringTokenizer l_st = new StringTokenizer(version, ".");
        for (int l_index = 0; l_st.hasMoreTokens() && l_index < 2; ++l_index) {
            String l_token = l_st.nextToken();
            int l_value = Integer.valueOf(l_token);
            l_bytes = ByteSeries.getBytes(l_value, 1);
            l_buffer.put(l_bytes, 0, l_bytes.length);
        }
        l_bytes = Arrays.copyOf(l_buffer.array(), l_buffer.position());
        return l_bytes;
    }

    protected String restoreVersion(byte[] bytes) {
        int l_major = ByteSeries.parseInt(bytes, 0, 1);
        int l_minor = ByteSeries.parseInt(bytes, 1, 1);
        String l_text = Integer.toString(l_major) + "." + Integer.toString(l_minor);
        return l_text;
    }

    public String getFormatSample() {
        return null;
    }

    public static void addFormat(ProductKeyFormat format) {
        formatMap.put(format.getName(), format);
    }

    public static ProductKeyFormat getInstance(String name) {
        return formatMap.get(name);
    }
}

