/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.product_key;

import com.valeras.copy_protection.ByteSeries;
import com.valeras.copy_protection.product_key.ProductKey;
import com.valeras.copy_protection.product_key.ProductKeyFormat;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import com.valeras.copy_protection.product_key.SerialNumber;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.text.ParseException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class ProductKeyBuilder {
    protected final ProductKeyFormat format;
    protected final Cipher cipher;
    protected final Key key;

    public ProductKeyBuilder(ProductKeyFormat format, Cipher cipher, Key key) {
        this.format = format;
        this.cipher = cipher;
        this.key = key;
    }

    public String getFormat() {
        return this.format.getName();
    }

    public ProductKey build(ProductKeyParams params) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ProductKey l_key = this.createProductKey(this.format);
        ByteSeries l_series = new ByteSeries(this.format.format(params));
        byte[] l_cleartext = ByteSeries.merge(l_series);
        this.cipher.init(1, this.key);
        byte[] l_ciphertext = this.cipher.doFinal(l_cleartext);
        l_series.setBytes(l_ciphertext);
        l_key.setByteSeries(l_series);
        return l_key;
    }

    public ProductKey parse(String serialNumber) throws ParseException, GeneralSecurityException {
        ProductKey l_key = this.createProductKey(this.format);
        ProductKeyParams l_params = this.createParams();
        List<byte[]> l_series = this.decrypt(serialNumber);
        this.format.parse(l_series, l_params);
        l_params.setReadOnly(true);
        l_key.setSerialNumber(serialNumber.toString());
        l_key.setParams(l_params);
        return l_key;
    }

    public List<byte[]> decrypt(String serialNumber) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, ParseException {
        ByteSeries l_series = new ByteSeries(new SerialNumber(serialNumber).getByteSeries());
        byte[] l_ciphertext = l_series.getBytes();
        this.cipher.init(2, this.key);
        byte[] l_plaintext = this.cipher.doFinal(l_ciphertext);
        l_series.setBytes(l_plaintext);
        return l_series;
    }

    protected ProductKey createProductKey(ProductKeyFormat format) {
        return new ProductKey(format.getName());
    }

    protected ProductKeyParams createParams() {
        return new ProductKeyParams();
    }
}

