/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.product_key;

import com.valeras.copy_protection.product_key.ProductKey;
import com.valeras.copy_protection.product_key.ProductKeyFormat;
import com.valeras.copy_protection.product_key.ProductKeyParams;
import com.valeras.copy_protection.product_key.ProductKeyValidator;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractProductKeyValidator
implements ProductKeyValidator {
    private static final String MSG_NOT_EQUALS = "Parameter:{0} does not match the given value:{1}.";
    private final String name;

    protected AbstractProductKeyValidator(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Object acquireParam(String name, ProductKeyParams params) {
        Object l_value = null;
        if (params != null) {
            l_value = params.get(name);
        }
        if (l_value == null) {
            l_value = this.provideParam(name);
        }
        return l_value;
    }

    protected abstract Object provideParam(String var1);

    protected void checkParam(ProductKey key, String name, Object value) throws GeneralSecurityException {
        Object l_restoredValue;
        ProductKeyFormat l_format = ProductKeyFormat.getInstance(key.getFormat());
        byte[] l_packedValue = l_format.packParam(name, value);
        try {
            l_restoredValue = l_format.restoreParam(name, l_packedValue);
        }
        catch (ParseException ex) {
            Logger.getLogger(AbstractProductKeyValidator.class.getName()).log(Level.SEVERE, null, ex);
            throw new GeneralSecurityException(ex);
        }
        if (!l_restoredValue.equals(key.getParam(name))) {
            throw new GeneralSecurityException(MessageFormat.format(MSG_NOT_EQUALS, name, value));
        }
    }
}

