/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.policies;

import com.valeras.copy_protection.AbstractLicenseValidationPolicy;
import com.valeras.copy_protection.attributes.ProductKeyAttribute;
import com.valeras.copy_protection.policies.ProductKeyPolicy;
import com.valeras.copy_protection.product_key.ProductKey;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;

public class ProductKeyValidationPolicy
extends AbstractLicenseValidationPolicy {
    public static final String POLICY_NAME = "cp.policy.license_validation.product_key";
    private static final String MSG_NO_KEY = "There is no product key to validate.";
    private static final String STR_NO_COMPONENT = "Required component is absent: {0}";
    protected ProductKeyAttribute keyAttribute;
    private ProductKeyPolicy keyPolicy;

    public ProductKeyValidationPolicy() {
        super(POLICY_NAME);
    }

    @Override
    protected void policyInit() {
        this.keyAttribute = (ProductKeyAttribute)this.cp.getAttribute("cp.attribute.product_key");
        this.keyPolicy = (ProductKeyPolicy)this.cp.getPolicy("cp.policy.product_key");
        if (this.keyPolicy == null) {
            throw new NullPointerException(MessageFormat.format(STR_NO_COMPONENT, "cp.policy.product_key"));
        }
    }

    @Override
    protected void policyValidate() throws GeneralSecurityException {
        ProductKey l_key = this.keyAttribute.getProductKey();
        if (l_key == null) {
            throw new GeneralSecurityException(MSG_NO_KEY);
        }
        this.keyPolicy.checkValidate(l_key);
    }
}

