/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.policies;

import com.valeras.copy_protection.AbstractLicenseValidationPolicy;
import com.valeras.copy_protection.attributes.EvaluationPeriodAttribute;
import com.valeras.copy_protection.attributes.TimeAttribute;
import com.valeras.copy_protection.event.SecurityNotificationEvent;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.SecurityPermission;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class ProductEvaluationPolicy
extends AbstractLicenseValidationPolicy {
    public static final Permission RESET_EVALUATION_PERIOD = new SecurityPermission("cp.reset_evaluation_period");
    public static final String POLICY_NAME = "cp.policy.product_evaluation";
    public static final int HINT_STARTED = 1;
    public static final int HINT_REMINDER = 2;
    public static final int HINT_EXPIRED = 3;
    private static final String STR_NO_ATTRIBUTE = "Required attribute is absent: {0}";
    private static final String STR_EXPIRED = "Evaluation period has expired.";
    private static final String STR_NO_PROPERTY = "Required property is absent: {0}.";
    private EvaluationPeriodAttribute evaluationPeriodAttribute;
    private Date dateExpired;
    private final int period;
    private final int[] reminders;
    private int remains;
    private boolean expired;

    public ProductEvaluationPolicy(int period, int[] reminders) {
        super(POLICY_NAME);
        this.period = period;
        this.reminders = Arrays.copyOf(reminders, reminders.length);
    }

    @Override
    protected void policyInit() {
        this.evaluationPeriodAttribute = (EvaluationPeriodAttribute)this.cp.getAttribute("cp.attribute.evaluation_period");
        if (this.evaluationPeriodAttribute == null) {
            throw new RuntimeException(MessageFormat.format(STR_NO_ATTRIBUTE, "cp.attribute.evaluation_period"));
        }
        this.dateExpired = null;
    }

    @Override
    protected void policyValidate() throws GeneralSecurityException {
        Date l_now = this.cp.getTime();
        if (this.dateExpired == null) {
            Date l_dateStart = this.evaluationPeriodAttribute.getDateStart();
            Calendar l_expired = Calendar.getInstance();
            if (l_dateStart == null) {
                throw new RuntimeException(MessageFormat.format(STR_NO_PROPERTY, "date_start"));
            }
            l_expired.setTime(l_dateStart);
            l_expired.add(6, this.period);
            this.dateExpired = l_expired.getTime();
        }
        this.remains = TimeAttribute.dayDiff(l_now, this.dateExpired);
        int l_lastReminder = this.evaluationPeriodAttribute.getReminder();
        if (this.evaluationPeriodAttribute.isExpired()) {
            this.expired = true;
        } else {
            boolean bl = this.expired = this.remains <= 0;
        }
        if (this.expired) {
            if (l_lastReminder > 0 || l_lastReminder == -1) {
                this.evaluationPeriodAttribute.setReminder(0);
                this.fireSecurityNotificationEvent(new SecurityNotificationEvent(this, 3, null));
            }
            throw new GeneralSecurityException(STR_EXPIRED);
        }
        if (l_lastReminder == -1) {
            this.evaluationPeriodAttribute.setReminder(this.period);
            this.fireSecurityNotificationEvent(new SecurityNotificationEvent(this, 1, new Integer(this.period)));
            return;
        }
        for (int i = this.reminders.length - 1; i >= 0; --i) {
            int r = this.reminders[i];
            if (this.remains > r || l_lastReminder <= r) continue;
            this.evaluationPeriodAttribute.setReminder(r);
            this.fireSecurityNotificationEvent(new SecurityNotificationEvent(this, 2, new Integer(this.remains)));
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public int getDayLeft() {
        return this.remains;
    }

    @Override
    public void reset() {
        this.evaluationPeriodAttribute.reset();
        this.evaluationPeriodAttribute.setDateStart(this.cp.getTime());
    }
}

