/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.attributes;

import com.valeras.copy_protection.AbstractSecurityAttribute;
import java.beans.PropertyChangeEvent;
import java.util.Calendar;
import java.util.Date;

public class TimeAttribute
extends AbstractSecurityAttribute {
    public static final String ATTRIBUTE_NAME = "cp.attribute.time";
    protected static final String KEY_TIMESTAMP = "timestamp";
    private long timestamp;

    public TimeAttribute() {
        super(ATTRIBUTE_NAME);
        this.registerProperty(KEY_TIMESTAMP);
    }

    @Override
    protected void attributeInit() {
        this.timestamp = 0L;
    }

    public long getRecentTimestamp() {
        return this.timestamp;
    }

    public Date getTime() {
        return new Date();
    }

    @Override
    public void update() {
        String l_oldValue = Long.toString(this.timestamp);
        long l_time = System.currentTimeMillis();
        if (l_time > this.timestamp) {
            this.timestamp = l_time;
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, KEY_TIMESTAMP, l_oldValue, Long.toString(this.timestamp)));
        }
    }

    @Override
    public void setProperty(String key, String value) {
        if (key.equals(KEY_TIMESTAMP)) {
            this.timestamp = value != null ? Long.parseLong(value) : 0L;
        }
    }

    @Override
    public String getProperty(String key) {
        String l_value = null;
        if (key.equals(KEY_TIMESTAMP)) {
            l_value = Long.toString(this.timestamp);
        }
        return l_value;
    }

    @Override
    public void reset() {
        String l_oldValue = Long.toString(this.timestamp);
        this.timestamp = System.currentTimeMillis();
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, KEY_TIMESTAMP, l_oldValue, Long.toString(this.timestamp)));
    }

    public static int dayDiff(Date date1, Date date2) {
        Calendar l_cl1 = Calendar.getInstance();
        Calendar l_cl2 = Calendar.getInstance();
        int l_count = 0;
        l_cl1.setTime(date1);
        l_cl2.setTime(date2);
        l_count = l_cl2.get(6) - l_cl1.get(6);
        if (l_cl2.get(1) > l_cl1.get(1)) {
            l_count += l_cl1.getActualMaximum(6);
        }
        return l_count;
    }
}

