/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.attributes;

import com.valeras.copy_protection.AbstractSecurityAttribute;
import com.valeras.copy_protection.product_key.ProductKey;
import com.valeras.copy_protection.product_key.ProductKeyBuilder;
import java.beans.PropertyChangeEvent;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProductKeyAttribute
extends AbstractSecurityAttribute {
    public static final String ATTRIBUTE_NAME = "cp.attribute.product_key";
    protected static final String KEY_PRODUCT_KEY = "key";
    private ProductKey productKey;
    private final ProductKeyBuilder keyBuilder;

    public ProductKeyAttribute(ProductKeyBuilder keyBuilder) {
        super(ATTRIBUTE_NAME);
        this.keyBuilder = keyBuilder;
        this.registerProperty(KEY_PRODUCT_KEY);
    }

    @Override
    public void attributeInit() {
        this.productKey = null;
    }

    public ProductKeyBuilder getKeyBuilder() {
        return this.keyBuilder;
    }

    public ProductKey getProductKey() {
        return this.productKey;
    }

    public void setProductKey(ProductKey productKey) {
        String l_oldValue = this.productKey != null ? this.productKey.toString() : null;
        this.productKey = productKey;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, KEY_PRODUCT_KEY, l_oldValue, productKey.toString()));
    }

    @Override
    public void update() {
    }

    @Override
    public void setProperty(String key, String value) {
        if (key.equals(KEY_PRODUCT_KEY)) {
            try {
                this.productKey = this.keyBuilder.parse(value);
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(ProductKeyAttribute.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParseException ex) {
                this.productKey = null;
                Logger.getLogger(ProductKeyAttribute.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        String l_value = null;
        if (key.equals(KEY_PRODUCT_KEY)) {
            l_value = this.productKey != null ? this.productKey.toString() : null;
        }
        return l_value;
    }

    @Override
    public void reset() {
        this.productKey = null;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, null, null, null));
    }
}

