/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection.attributes;

import com.valeras.copy_protection.AbstractSecurityAttribute;
import java.beans.PropertyChangeEvent;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvaluationPeriodAttribute
extends AbstractSecurityAttribute {
    public static final String ATTRIBUTE_NAME = "cp.attribute.evaluation_period";
    public static final String KEY_DATE_START = "date_start";
    public static final String KEY_REMINDER = "reminder";
    public static final String KEY_EXPIRED = "expired";
    private Date dateStart;
    private int reminder;
    private boolean expired;

    public EvaluationPeriodAttribute() {
        super(ATTRIBUTE_NAME);
        this.registerProperty(KEY_DATE_START);
        this.registerProperty(KEY_REMINDER);
        this.registerProperty(KEY_EXPIRED);
    }

    @Override
    protected void attributeInit() {
        this.dateStart = null;
        this.reminder = -1;
        this.expired = false;
    }

    @Override
    public void update() {
    }

    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date date) {
        this.dateStart = date;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean flag) {
        this.expired = flag;
    }

    public int getReminder() {
        return this.reminder;
    }

    public void setReminder(int reminder) {
        this.reminder = reminder;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key.equals(KEY_DATE_START)) {
            try {
                this.dateStart = value != null ? defaultDateFormat.parse(value) : null;
            }
            catch (ParseException ex) {
                Logger.getLogger(EvaluationPeriodAttribute.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (key.equals(KEY_REMINDER)) {
            this.reminder = value != null ? Integer.parseInt(value) : 0;
        } else if (key.equals(KEY_EXPIRED)) {
            this.expired = value != null ? Boolean.parseBoolean(value) : false;
        }
    }

    @Override
    public String getProperty(String key) {
        String l_value = null;
        if (key.equals(KEY_DATE_START)) {
            l_value = this.dateStart != null ? defaultDateFormat.format(this.dateStart) : null;
        } else if (key.equals(KEY_REMINDER)) {
            l_value = Integer.toString(this.reminder);
        } else if (key.equals(KEY_EXPIRED)) {
            l_value = Boolean.toString(this.expired);
        }
        return l_value;
    }

    @Override
    public void reset() {
        this.dateStart = null;
        this.reminder = -1;
        this.expired = false;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, null, null, null));
    }
}

