/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection;

import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.ProductFunctionality;
import com.valeras.copy_protection.SecurityComponent;
import com.valeras.copy_protection.event.SecurityNotificationEvent;
import com.valeras.copy_protection.event.SecurityNotificationListener;
import com.valeras.copy_protection.policies.ProductFunctionalityPolicy;
import java.security.GeneralSecurityException;
import java.security.PermissionCollection;
import java.util.ArrayList;

public class LicensingModel
implements SecurityComponent,
SecurityNotificationListener {
    private final String name;
    private CopyProtection cp;
    protected final ArrayList<LicenseValidationPolicy> policies;
    protected final ProductFunctionalityPolicy productFunctionalityPolicy;
    private LicenseValidationPolicy mainPolicy;
    private LicenseValidationPolicy effectivePolicy;
    private boolean licenseVerified;

    public LicensingModel(String name, ProductFunctionalityPolicy functionalityPolicy) {
        this.name = name;
        this.policies = new ArrayList();
        this.productFunctionalityPolicy = functionalityPolicy;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected CopyProtection getCopyProtection() {
        return this.cp;
    }

    public void addPolicy(LicenseValidationPolicy policy) {
        this.policies.add(policy);
        policy.addSecurityNotificationListener(this);
    }

    public void setMainPolicy(LicenseValidationPolicy policy) {
        this.mainPolicy = policy;
    }

    public LicenseValidationPolicy getPolicy(String name) {
        for (LicenseValidationPolicy p : this.policies) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public LicenseValidationPolicy getEffectivePolicy() {
        return this.effectivePolicy;
    }

    @Override
    public void componentInit(CopyProtection cp) {
        this.cp = cp;
        this.licenseVerified = false;
        if (this.mainPolicy == null) {
            this.mainPolicy = this.policies.get(0);
        }
        this.effectivePolicy = this.mainPolicy;
        for (LicenseValidationPolicy p : this.policies) {
            p.componentInit(cp);
        }
    }

    public void reset(PermissionCollection permissions) {
        this.licenseVerified = false;
        this.effectivePolicy = this.mainPolicy;
    }

    public void verify() throws GeneralSecurityException {
        GeneralSecurityException l_failCause = null;
        this.licenseVerified = false;
        for (LicenseValidationPolicy p : this.policies) {
            try {
                p.validate();
                if (!p.isValidated()) continue;
                this.effectivePolicy = p;
                this.licenseVerified = true;
                break;
            }
            catch (GeneralSecurityException ex) {
                if (!p.equals(this.mainPolicy)) continue;
                l_failCause = ex;
            }
        }
        if (!this.licenseVerified) {
            this.effectivePolicy = this.mainPolicy;
            throw l_failCause;
        }
    }

    public boolean isVerified() {
        return this.licenseVerified;
    }

    protected void setVerified(boolean validated) {
        this.licenseVerified = validated;
    }

    public void revalidate(LicenseValidationPolicy policy) throws GeneralSecurityException {
        policy.validate();
        if (policy.isValidated()) {
            this.effectivePolicy = policy;
            this.licenseVerified = true;
            this.cp.setLicenseValidated(true);
        }
    }

    public ProductFunctionality getProductFunctionality() {
        return this.productFunctionalityPolicy.functionalityFor(this.effectivePolicy);
    }

    @Override
    public void notificationReceived(SecurityNotificationEvent event) {
        this.cp.putNotification(event);
    }
}

