/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection;

import com.valeras.copy_protection.LicensingModel;
import com.valeras.copy_protection.PropertyStorage;
import com.valeras.copy_protection.SecurityAttribute;
import com.valeras.copy_protection.SecurityPolicy;
import com.valeras.copy_protection.attributes.TimeAttribute;
import com.valeras.copy_protection.event.SecurityNotificationEvent;
import java.io.Closeable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;

public class CopyProtection {
    public static final Permission RESET_SECUTITY = new SecurityPermission("cp.reset_security_policies");
    private static final String MSG_NO_INSTANCE = "There is no active instance of copy protection.";
    private static CopyProtection cp = null;
    private final ArrayList<SecurityNotificationEvent> notifications;
    private final ArrayList<SecurityAttribute> attributes = new ArrayList();
    private final ArrayList<SecurityPolicy> policies = new ArrayList();
    protected final LicensingModel licensingModel;
    private final PropertyStorage storage;
    private SecurityPolicy failedPolicy;
    private boolean valid;

    public CopyProtection(LicensingModel licensingModel, PropertyStorage storage) {
        this.notifications = new ArrayList();
        this.licensingModel = licensingModel;
        this.storage = storage;
        this.valid = false;
        this.failedPolicy = null;
    }

    public void addAttribute(SecurityAttribute attribute) {
        this.attributes.add(attribute);
    }

    public SecurityAttribute getAttribute(String name) {
        for (SecurityAttribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public void addPolicy(SecurityPolicy policy) {
        this.policies.add(policy);
    }

    public SecurityPolicy getPolicy(String name) {
        for (SecurityPolicy p : this.policies) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public SecurityPolicy getFailedPolicy() {
        return this.failedPolicy;
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    public LicensingModel getLicensingModel() {
        return this.licensingModel;
    }

    protected void cpInit() throws GeneralSecurityException {
        for (SecurityAttribute a : this.attributes) {
            a.componentInit(cp);
        }
        if (this.storage != null) {
            try {
                this.storage.storageInit(this.attributes);
                this.storage.fetch();
            }
            catch (BackingStoreException ex) {
                // empty catch block
            }
        }
        for (SecurityPolicy p : this.policies) {
            p.componentInit(cp);
        }
        this.licensingModel.componentInit(this);
    }

    protected void cpStop() throws GeneralSecurityException {
        if (this.storage != null && this.storage.isEnabled()) {
            this.storage.update();
            if (this.storage instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.storage)).close();
                }
                catch (IOException ex) {
                    throw new GeneralSecurityException(ex);
                }
            }
        }
        for (SecurityAttribute a : this.attributes) {
            a.displose();
        }
    }

    public void reset(PermissionCollection permissions) throws GeneralSecurityException {
        this.notifications.clear();
        if (permissions.implies(RESET_SECUTITY)) {
            for (SecurityPolicy p : this.policies) {
                p.reset();
            }
        }
        this.licensingModel.reset(permissions);
        if (this.storage != null && this.storage.isEnabled()) {
            this.storage.update();
        }
    }

    public void check() throws GeneralSecurityException {
        GeneralSecurityException l_failCause = null;
        this.notifications.clear();
        this.valid = false;
        this.failedPolicy = null;
        for (SecurityAttribute a : this.attributes) {
            a.update();
        }
        for (SecurityPolicy p : this.policies) {
            try {
                p.validate();
            }
            catch (GeneralSecurityException ex) {
                this.failedPolicy = p;
                l_failCause = ex;
            }
        }
        if (this.failedPolicy == null) {
            try {
                this.licensingModel.verify();
            }
            catch (GeneralSecurityException ex) {
                this.failedPolicy = this.licensingModel.getEffectivePolicy();
                l_failCause = ex;
            }
        }
        if (this.storage != null && this.storage.isEnabled()) {
            this.storage.update();
        }
        this.valid = this.confirm(this.licensingModel, this.failedPolicy != null ? this.failedPolicy : this.licensingModel.getEffectivePolicy(), l_failCause);
    }

    protected boolean confirm(LicensingModel model, SecurityPolicy policy, Throwable failCause) throws GeneralSecurityException {
        if (failCause != null) {
            throw new GeneralSecurityException(failCause);
        }
        return true;
    }

    public boolean isLicenseValidated() {
        return this.valid;
    }

    public void setLicenseValidated(boolean flag) {
        this.valid = flag;
    }

    public static void setCopyProtection(CopyProtection cp) throws GeneralSecurityException {
        CopyProtection.cp = cp;
        cp.cpInit();
    }

    public static CopyProtection getCopyProtection() {
        return cp;
    }

    public static boolean isEnabled() {
        return cp != null;
    }

    public static void stop() throws GeneralSecurityException {
        if (cp == null) {
            throw new GeneralSecurityException(MSG_NO_INSTANCE);
        }
        cp.cpStop();
    }

    public void putNotification(SecurityNotificationEvent notification) {
        this.notifications.add(notification);
    }

    public boolean hasNotification() {
        return this.notifications.size() > 0;
    }

    public Iterator<SecurityNotificationEvent> notificationIterator() {
        return this.notifications.iterator();
    }

    public Date getTime() {
        TimeAttribute l_timeAttribute = (TimeAttribute)cp.getAttribute("cp.attribute.time");
        return l_timeAttribute != null ? l_timeAttribute.getTime() : new Date();
    }
}

