/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ByteSeries
extends ArrayList<byte[]>
implements Cloneable {
    public ByteSeries() {
    }

    public ByteSeries(List<byte[]> series) {
        this.setSeries(series);
    }

    @Override
    public Object clone() {
        ByteSeries l_clone = (ByteSeries)super.clone();
        l_clone.setSeries(this);
        return l_clone;
    }

    public final void setSeries(List<byte[]> series) {
        this.clear();
        for (byte[] bytes : series) {
            this.add(Arrays.copyOf(bytes, bytes.length));
        }
    }

    public byte[] getBytes() {
        return ByteSeries.merge(this);
    }

    public void setBytes(byte[] bytes) {
        int l_offset = 0;
        for (int i = 0; i < this.size(); ++i) {
            byte[] l_bytes = (byte[])this.get(i);
            int l_count = l_bytes.length;
            this.set(i, Arrays.copyOfRange(bytes, l_offset, l_offset + l_count));
            l_offset += l_count;
        }
    }

    public static List<byte[]> parse(String series, String delimiter) throws ParseException {
        ArrayList<byte[]> l_series = new ArrayList<byte[]>();
        StringTokenizer l_st = new StringTokenizer(series, delimiter);
        while (l_st.hasMoreTokens()) {
            String l_token = l_st.nextToken();
            l_series.add(ByteSeries.parse(l_token));
        }
        return l_series;
    }

    public static byte[] parse(String str) throws ParseException {
        if (str.length() % 2 == 1) {
            throw new ParseException(str, 0);
        }
        int l_count = str.length() / 2;
        ByteBuffer l_buffer = ByteBuffer.allocate(l_count);
        for (int i = 0; i < l_count; ++i) {
            String b = str.substring(i * 2, i * 2 + 2);
            int l_value = Integer.parseInt(b, 16);
            l_buffer.put((byte)l_value);
        }
        byte[] l_bytes = Arrays.copyOf(l_buffer.array(), l_buffer.position());
        return l_bytes;
    }

    public static String toString(byte[] bytes) {
        String l_text = "";
        for (int i = 0; i < bytes.length; ++i) {
            int l_value = bytes[i];
            String l_str = Integer.toHexString(l_value &= 0xFF);
            if (l_str.length() == 1) {
                l_str = "0" + l_str;
            }
            l_text = l_text + l_str;
        }
        return l_text.toUpperCase();
    }

    public static int hashCode(byte[] series) {
        int h = 1;
        for (int i = 0; i < series.length; ++i) {
            h = 31 * h + series[i];
        }
        return h;
    }

    public static byte[] getBytes(int value, int count) {
        byte[] l_bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            l_bytes[count - i - 1] = (byte)(value >> i * 8 & 0xFF);
        }
        return l_bytes;
    }

    public static int parseInt(byte[] bytes) {
        int l_value = 0;
        int i = bytes.length - 1;
        int r = 0;
        while (i >= 0) {
            l_value += (bytes[i] & 0xFF) << r * 8;
            --i;
            ++r;
        }
        return l_value;
    }

    public static int parseInt(byte[] bytes, int offset, int length) {
        int l_value = 0;
        int i = length - 1;
        int r = 0;
        while (i >= 0) {
            l_value += (bytes[offset + i] & 0xFF) << r * 8;
            --i;
            ++r;
        }
        return l_value;
    }

    public static byte[] merge(List<byte[]> series) {
        byte[] l_bytes = null;
        int l_count = 0;
        for (byte[] s : series) {
            l_count += s.length;
        }
        ByteBuffer l_buffer = ByteBuffer.allocate(l_count);
        for (int i = 0; i < series.size(); ++i) {
            l_bytes = series.get(i);
            l_buffer.put(l_bytes, 0, l_bytes.length);
        }
        if (!l_buffer.hasArray()) {
            l_bytes = null;
            throw new RuntimeException("ByteBuffer does not provide access to array().");
        }
        l_bytes = Arrays.copyOf(l_buffer.array(), l_buffer.position());
        return l_bytes;
    }

    @Override
    public String toString() {
        String l_text = "";
        String l_delimiter = " ";
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                l_text = l_text + " ";
            }
            l_text = l_text + ByteSeries.toString((byte[])this.get(i));
        }
        return l_text;
    }
}

