/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection;

import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.SecurityAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public abstract class AbstractSecurityAttribute
implements SecurityAttribute {
    protected static final String DEFAULT_DATEFORMAT_PATTERN = "yyyy-MM-dd";
    protected static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final ArrayList<String> propertyNames = new ArrayList();
    private final ArrayList<PropertyChangeListener> propertyChangeListeners = new ArrayList();
    private final String name;
    private CopyProtection cp;

    protected AbstractSecurityAttribute(String name) {
        this.name = name;
    }

    protected void registerProperty(String name) {
        this.propertyNames.add(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContainerName() {
        return this.name;
    }

    @Override
    public final void componentInit(CopyProtection cp) {
        this.cp = cp;
        this.attributeInit();
    }

    protected abstract void attributeInit();

    @Override
    public void displose() {
    }

    @Override
    public Enumeration<String> propertyNames() {
        return Collections.enumeration(this.propertyNames);
    }

    protected CopyProtection getCopyProtection() {
        return this.cp;
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }
}

