/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.copy_protection;

import com.valeras.copy_protection.CopyProtection;
import com.valeras.copy_protection.LicenseValidationPolicy;
import com.valeras.copy_protection.event.SecurityNotificationEvent;
import com.valeras.copy_protection.event.SecurityNotificationListener;
import java.security.GeneralSecurityException;
import java.util.ArrayList;

public abstract class AbstractLicenseValidationPolicy
implements LicenseValidationPolicy {
    private final ArrayList<SecurityNotificationListener> securityNotificationListeners;
    private final String name;
    protected CopyProtection cp;
    private boolean validated;

    protected AbstractLicenseValidationPolicy(String name) {
        this.name = name;
        this.securityNotificationListeners = new ArrayList();
    }

    @Override
    public final boolean isValidated() {
        return this.validated;
    }

    protected void setValidated(boolean flag) {
        this.validated = flag;
    }

    @Override
    public final void validate() throws GeneralSecurityException {
        this.validated = false;
        this.policyValidate();
        this.validated = true;
    }

    protected abstract void policyValidate() throws GeneralSecurityException;

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void componentInit(CopyProtection cp) {
        this.cp = cp;
        this.validated = false;
        this.policyInit();
    }

    protected abstract void policyInit();

    @Override
    public void reset() {
    }

    @Override
    public void addSecurityNotificationListener(SecurityNotificationListener listener) {
        this.securityNotificationListeners.add(listener);
    }

    @Override
    public void removeSecurityNotificationListener(SecurityNotificationListener listener) {
        this.securityNotificationListeners.remove(listener);
    }

    protected void fireSecurityNotificationEvent(SecurityNotificationEvent event) {
        for (SecurityNotificationListener l : this.securityNotificationListeners) {
            l.notificationReceived(event);
        }
    }
}

