/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.view2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Projection2D
extends AffineTransform
implements Cloneable {
    private ArrayList<ChangeListener> changeListeners;
    protected final ChangeEvent changeEvent;
    private boolean zoomRelCP = true;
    private double zoomStep = 0.1;
    protected Rectangle2D modelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    protected Rectangle2D userBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);

    public Projection2D() {
        this.changeListeners = new ArrayList();
        this.changeEvent = new ChangeEvent(this);
    }

    public void setModelBounds(Rectangle2D bounds) {
        this.modelBounds = bounds != null ? (Rectangle2D)bounds.clone() : null;
    }

    public void setUserBounds(Rectangle2D bounds) {
        this.userBounds = (Rectangle2D)bounds.clone();
    }

    public Rectangle2D getUserBounds() {
        return (Rectangle2D)this.userBounds.clone();
    }

    public void setZoomStep(double amount) {
        this.zoomStep = amount;
    }

    public double getZoomStep() {
        return this.zoomStep;
    }

    public void reset() {
        this.setToTranslation(0.0, 0.0);
        this.scale(1.0, 1.0);
        this.fireChangeEvent();
    }

    public void center() {
        double l_ty;
        double l_tx;
        double l_sx = this.getScaleX();
        double l_sy = this.getScaleY();
        if (this.modelBounds == null || this.userBounds == null) {
            return;
        }
        if (this.zoomRelCP) {
            l_tx = (this.userBounds.getWidth() - this.modelBounds.getWidth() * l_sx) / 2.0;
            l_ty = (this.userBounds.getHeight() - this.modelBounds.getHeight() * l_sy) / 2.0;
        } else {
            l_tx = 0.0;
            l_ty = 0.0;
        }
        this.setToTranslation(l_tx, l_ty);
        this.scale(l_sx, l_sy);
        this.fireChangeEvent();
    }

    public void zoomToFit() {
        double l_ty;
        double l_tx;
        double l_scale;
        if (this.modelBounds == null || this.userBounds == null) {
            return;
        }
        double l_sx = this.userBounds.getWidth() / this.modelBounds.getWidth();
        double l_sy = this.userBounds.getHeight() / this.modelBounds.getHeight();
        l_sx = l_scale = Math.min(l_sx, l_sy);
        l_sy = l_scale;
        if (this.zoomRelCP) {
            l_tx = (this.userBounds.getWidth() - this.modelBounds.getWidth() * l_sx) / 2.0;
            l_ty = (this.userBounds.getHeight() - this.modelBounds.getHeight() * l_sy) / 2.0;
        } else {
            l_tx = 0.0;
            l_ty = 0.0;
        }
        this.setToTranslation(l_tx, l_ty);
        this.scale(l_sx, l_sy);
        this.fireChangeEvent();
    }

    public void zoomIn() {
        this.zoom(1.0 + this.zoomStep);
    }

    public void zoomOut() {
        this.zoom(1.0 - this.zoomStep);
    }

    public void zoom(double amount) {
        double l_sx = this.getScaleX();
        double l_sy = this.getScaleY();
        double l_tx = this.getTranslateX();
        double l_ty = this.getTranslateY();
        Point2D l_cp = null;
        try {
            l_cp = this.inverseTransform(new Point2D.Double(this.userBounds.getCenterX(), this.userBounds.getCenterY()), null);
        }
        catch (NoninvertibleTransformException ex) {
            Logger.getLogger(Projection2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        l_sx *= amount;
        l_sy *= amount;
        if (l_cp != null) {
            this.setToScale(l_sx, l_sy);
            Point2D l_p1 = this.transform(l_cp, null);
            l_tx = this.userBounds.getCenterX() - l_p1.getX();
            l_ty = this.userBounds.getCenterY() - l_p1.getY();
        }
        this.setToTranslation(l_tx, l_ty);
        this.scale(l_sx, l_sy);
        this.fireChangeEvent();
    }

    public void moveRel(double dx, double dy) {
        double l_sx = this.getScaleX();
        double l_sy = this.getScaleY();
        double l_tx = this.getTranslateX();
        double l_ty = this.getTranslateY();
        this.setToTranslation(l_tx += dx, l_ty += dy);
        this.scale(l_sx, l_sy);
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireChangeEvent() {
        for (ChangeListener l : this.changeListeners) {
            l.stateChanged(this.changeEvent);
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

