/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.view2d;

import com.valeras.colorwheel_harmony.ui.view2d.Projection2D;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.event.MouseInputAdapter;

public class MouseAdapter2D
extends MouseInputAdapter {
    private Component component = null;
    private Projection2D projection = null;
    private boolean enabled = true;
    private Point recentPoint = null;
    private boolean inverseWheel = false;

    public MouseAdapter2D(Projection2D pr) {
        this.projection = pr;
    }

    public MouseAdapter2D() {
        this.projection = null;
    }

    public void setComponent(Component c) {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseMotionListener(this);
            this.component.removeMouseWheelListener(this);
        }
        this.component = c;
        if (this.component != null) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
            this.component.addMouseWheelListener(this);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setProjection(Projection2D projection) {
        this.projection = projection;
    }

    public Projection2D getProjection() {
        return this.projection;
    }

    public void setInverseWheel(boolean flag) {
        this.inverseWheel = flag;
    }

    public boolean isInverseWheel() {
        return this.inverseWheel;
    }

    protected boolean isDragEvent(MouseEvent e) {
        return (e.getModifiersEx() & 0x400) == 1024;
    }

    protected boolean isZoomEvent(MouseWheelEvent e) {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled() || this.isDragEvent(e) && this.projection != null) {
            this.recentPoint = e.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point l_pnt = (Point)e.getPoint().clone();
        if (!this.isEnabled() || !this.isDragEvent(e) || this.projection == null) {
            return;
        }
        if (this.recentPoint == null) {
            this.recentPoint = l_pnt;
            return;
        }
        this.projection.moveRel(l_pnt.x - this.recentPoint.x, l_pnt.y - this.recentPoint.y);
        this.recentPoint = l_pnt;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double l_zoom = 1.0;
        if (!this.isEnabled() || !this.isZoomEvent(e) || this.projection == null) {
            return;
        }
        int l_amount = e.getWheelRotation();
        boolean l_increase = l_amount < 0;
        l_amount = Math.abs(l_amount);
        double l_step = this.projection.getZoomStep();
        if (this.isInverseWheel()) {
            l_step = -l_step;
        }
        for (int i = 0; i < l_amount; ++i) {
            l_zoom *= 1.0 + (l_increase ? l_step : -l_step);
        }
        this.projection.zoom(l_zoom);
    }
}

