/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.windows;

import com.valeras.color_chart.ColorChart;
import com.valeras.color_chart.ColorChartEntry;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorDetails;
import com.valeras.colorwheel_harmony.model.ColorSetter;
import com.valeras.colorwheel_harmony.ui.model.ColorChartView;
import com.valeras.colorwheel_harmony.ui.swing.components.JxAssortmentPanel;
import com.valeras.colorwheel_harmony.ui.swing.model.ColorChartSelectionModel;
import com.valeras.colorwheel_harmony.ui.swing.renderer.ColorChartEntryCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorChartWindow
extends JFrame
implements ColorChartView {
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 400);
    private static final String STR_NO_COLOR_CHART = "window.color_chart.str.no_color_chart";
    private static final String STR_SCROLL_TO_SELECTION = "window.color_chart.str.scroll_to_selection";
    private static final ColorChartSelector CCS_COLOR_MATHING = new ColorChartSelector(2, null);
    private final JPanel toolPanel;
    private final JPanel selectionPanel;
    private final JPanel titlePanel;
    private ComboBoxModel selectorModel;
    private ColorChart matchingColorChart;
    private ColorSetter colorSetter;
    private final ItemListener colorChartSelectionListener;
    private final ComboBoxModel viewSelectionModel;
    private final JComboBox cmColorChart;
    private final JComboBox cmShowMode;
    private final JCheckBox cbShowSelected;
    private final JLabel lblColorChart;
    private final String viewAllColors;
    private final String viewSimilarColors;
    private final JxAssortmentPanel view;
    private final AssortmentListSelectionListener assortmentListSelectionListener;
    private ColorChartSelectionModel model;
    private final ColorChartSelectionModel emptyModel;

    public ColorChartWindow(JFrame parent) {
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(1);
        this.model = this.emptyModel = new ColorChartSelectionModel();
        this.view = new JxAssortmentPanel(new ColorChartEntryCellRenderer());
        this.assortmentListSelectionListener = new AssortmentListSelectionListener();
        this.view.addListSelectionListener(this.assortmentListSelectionListener);
        this.view.setPreferredSize(DEFAULT_SIZE);
        this.toolPanel = new JPanel();
        this.selectionPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.toolPanel.setLayout(new BorderLayout());
        this.toolPanel.setOpaque(false);
        this.lblColorChart = new JLabel(StringTable.get(STR_NO_COLOR_CHART));
        this.selectorModel = this.createColorChartSelectionModel(null);
        this.colorChartSelectionListener = new ColorChartSelectionListener();
        this.matchingColorChart = null;
        this.colorSetter = null;
        this.viewAllColors = "All colors";
        this.viewSimilarColors = "Similar colors";
        Object[] l_viewChoices = new Object[]{this.viewAllColors, this.viewSimilarColors};
        this.viewSelectionModel = new DefaultComboBoxModel<Object>(l_viewChoices);
        this.cmColorChart = new JComboBox(this.selectorModel);
        this.cmColorChart.addItemListener(this.colorChartSelectionListener);
        this.cmShowMode = new JComboBox(this.viewSelectionModel);
        this.cbShowSelected = new JCheckBox(StringTable.get(STR_SCROLL_TO_SELECTION), true);
        this.selectionPanel.setLayout(new FlowLayout(0));
        this.selectionPanel.add(new JLabel("Color Chart:"));
        this.selectionPanel.add(this.cmColorChart);
        this.selectionPanel.add(this.cbShowSelected);
        this.titlePanel.setLayout(new FlowLayout(0));
        this.titlePanel.add(this.lblColorChart);
        this.toolPanel.add((Component)this.selectionPanel, "Center");
        this.toolPanel.add((Component)this.titlePanel, "South");
        this.add((Component)this.toolPanel, "North");
        this.add((Component)this.view, "Center");
        this.updateColorChartTitle(null);
        this.pack();
    }

    @Override
    public void setColorSetter(ColorSetter setter) {
        this.colorSetter = setter;
    }

    private ComboBoxModel createColorChartSelectionModel(Collection<ColorChart> colorCharts) {
        ArrayList<ColorChartSelector> l_choices = new ArrayList<ColorChartSelector>();
        l_choices.add(CCS_COLOR_MATHING);
        if (colorCharts != null) {
            for (ColorChart cc : colorCharts) {
                l_choices.add(new ColorChartSelector(3, cc));
            }
        }
        return new DefaultComboBoxModel<Object>(l_choices.toArray());
    }

    @Override
    public void setColorCharts(Collection<ColorChart> colorCharts) {
        Object l_selection = this.selectorModel.getSelectedItem();
        this.selectorModel = this.createColorChartSelectionModel(colorCharts);
        this.selectorModel.setSelectedItem(l_selection);
        this.cmColorChart.setModel(this.selectorModel);
    }

    @Override
    public void setColorChart(ColorChart colorChart) {
        this.model = colorChart != null ? new ColorChartSelectionModel(colorChart) : this.emptyModel;
        this.view.setAssortmentModel(this.model);
        this.updateColorChartTitle(colorChart);
    }

    private void updateColorChartTitle(ColorChart colorChart) {
        String l_text = colorChart != null ? colorChart.getDisplayName() : StringTable.get(STR_NO_COLOR_CHART);
        l_text = "<html><strong>" + l_text + "</strong>";
        l_text = l_text + (colorChart != null ? " (" + colorChart.size() + " entries)</html>" : "</html>");
        this.lblColorChart.setText(l_text);
    }

    @Override
    public void setMatchingColorChart(ColorChart colorChart) {
        this.matchingColorChart = colorChart;
        if (((ColorChartSelector)this.selectorModel.getSelectedItem()).getType() == 2) {
            this.setColorChart(colorChart);
        }
    }

    @Override
    public void setSelectedColor(Color color) {
        ColorDetails l_details;
        ColorChartEntry l_entry;
        ColorChart l_colorChart;
        if (!this.cbShowSelected.isSelected()) {
            return;
        }
        ColorChart colorChart = l_colorChart = this.model != null ? this.model.getColorChart() : null;
        if (l_colorChart != null && color != null && (l_entry = (l_details = ColorDetails.getDetails(color)).getColorChartEntry()) != null && !l_entry.equals(this.model.getSelectedItem())) {
            this.assortmentListSelectionListener.setEnabled(false);
            this.view.setAssortmentValue(l_entry, true);
            this.assortmentListSelectionListener.setEnabled(true);
        }
    }

    private class AssortmentListSelectionListener
    implements ListSelectionListener {
        private boolean enabled = true;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ColorChartEntry l_entry;
            if (!e.getValueIsAdjusting() && ColorChartWindow.this.colorSetter != null && this.enabled && (l_entry = (ColorChartEntry)ColorChartWindow.this.view.getAssortmentValue()) != null) {
                ColorChart l_colorChart = l_entry.getColorChart();
                ColorChartWindow.this.colorSetter.setColor(l_colorChart.getColor(l_colorChart.getEntryIdentifier(l_entry)));
            }
        }
    }

    private class ColorChartSelectionListener
    implements ItemListener {
        private ColorChartSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ColorChartSelector l_selector = (ColorChartSelector)e.getItem();
                switch (l_selector.getType()) {
                    case 2: {
                        ColorChartWindow.this.setColorChart(ColorChartWindow.this.matchingColorChart);
                        break;
                    }
                    case 3: {
                        ColorChartWindow.this.setColorChart(l_selector.getColorChart());
                    }
                }
            }
        }
    }

    private static class ColorChartSelector {
        public static final int SELECT_COLOR_MATCHING = 2;
        public static final int SELECT_COLOR_CHART = 3;
        private static final String STR_WRONG_MODE = "Wrong selection mode passed {0}";
        private int what;
        private ColorChart colorChart;
        private final String caption;

        public ColorChartSelector(int what, ColorChart colorChart) {
            this.what = what;
            this.colorChart = colorChart;
            switch (what) {
                case 2: {
                    this.caption = "<Color Matching>";
                    break;
                }
                case 3: {
                    this.caption = colorChart.getDisplayName();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(STR_WRONG_MODE, new Integer(what)));
                }
            }
        }

        public int getType() {
            return this.what;
        }

        public ColorChart getColorChart() {
            return this.colorChart;
        }

        public String toString() {
            return this.caption;
        }
    }
}

