/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.ui_defaults;

import com.valeras.colorwheel_harmony.app_core.AbstractColorWheelApplication;
import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.model.RYBColors;
import com.valeras.colorwheel_harmony.ui.swing.AbstractApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorSchemeIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorSourceIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractColorWheelSkinFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractDropShadowBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractNoColorPaintFactory;
import com.valeras.colorwheel_harmony.ui.swing.AbstractOffWhiteColorFactory;
import com.valeras.colorwheel_harmony.ui.swing.BasicPaletteLayoutProvider;
import com.valeras.colorwheel_harmony.ui.swing.DefaultApplicationIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultColorSchemeIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultColorSourceIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultColorWheelIconFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultColorWheelSkinFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultDropShadowBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultNoColorPaintFactory;
import com.valeras.colorwheel_harmony.ui.swing.DefaultOffWhiteColorFactory;
import com.valeras.colorwheel_harmony.ui.swing.JLFGRIconProvider;
import com.valeras.colorwheel_harmony.ui.swing.PaletteLayoutProvider;
import com.valeras.colorwheel_harmony.ui.swing.ui_defaults.LookAndFeelUIDefaults;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class BasicLookAndFeelUIDefaults
extends LookAndFeelUIDefaults {
    private static final String CROSS_PLATFORM_LNF = "Nimbus";
    private static final int DEFAULT_SMALL_ICON_SIZE = 16;
    private static final int DEFAULT_ARC = 12;
    private static final int HIRES_ARC = 16;
    private static final float DEFAULT_GRIDLINE_WIDTH = 2.0f;
    private static final float HIRES_GRIDLINE_WIDTH = 2.0f;
    private static final float DEFAULT_OUTLINE_WIDTH = 3.0f;
    private static final float HIRES_OUTLINE_WIDTH = 3.0f;
    private static final Color OFF_WHITE_COLOR = new Color(240, 240, 240);
    private static final float DEFAULT_SHADOW_OPACITY = 0.5f;
    private static final Point DEFAULT_SHADOW_DIRECTION = new Point(6, 6);
    private static final Point HIRES_SHADOW_DIRECTION = new Point(8, 8);
    private static final Insets DEFAULT_COMPONENT_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets DEFAULT_SHADOW_INSETS = new Insets(1, 1, 1, 1);
    private int defaultRoundSize;

    @Override
    public void installUIDefaults(ApplicationSettings settings) {
        String UIMANAGER_LABELFONT_KEY = "Label.font";
        String UIMANAGER_MENUITEMFONT_KEY = "MenuItem.font";
        Color defaultBackgroundColor = Color.WHITE;
        Color defaultForegroundColor = Color.BLACK;
        Color offWhiteColor = OFF_WHITE_COLOR;
        Color defaultGridlineColor = Color.black;
        Color defaultOutlineColor = Color.darkGray;
        float defaultShadowOpacity = 0.5f;
        Insets defaultShadowInsets = DEFAULT_SHADOW_INSETS;
        boolean l_nativeLNF = settings.getDefaultLNFEnabled();
        boolean l_hires = settings.getLargeColorCards();
        if (!l_nativeLNF) {
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!CROSS_PLATFORM_LNF.equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    l_nativeLNF = false;
                    break;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractColorWheelApplication.class.getName()).log(Level.SEVERE, null, ex);
                l_nativeLNF = true;
            }
        }
        if (l_nativeLNF) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception ex) {
                Logger.getLogger(AbstractColorWheelApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.defaultRoundSize = l_hires ? 16 : 12;
        float defaultGridlineWidth = l_hires ? 2.0f : 2.0f;
        float defaultOutlineWidth = l_hires ? 3.0f : 3.0f;
        Point defaultShadowDirection = l_hires ? HIRES_SHADOW_DIRECTION : DEFAULT_SHADOW_DIRECTION;
        Font defaultFont = UIManager.getFont("Label.font");
        if (defaultFont == null) {
            defaultFont = new Font(null, 0, 10);
        }
        int defaultExtent = l_hires ? 48 : 32;
        Dimension preferredColorCardSize = new Dimension(defaultExtent * 3, defaultExtent * 4);
        defaultShadowInsets.top = defaultShadowInsets.top + (defaultShadowDirection.y < 0 ? defaultShadowDirection.y : 0);
        defaultShadowInsets.left = defaultShadowInsets.left + (defaultShadowDirection.x < 0 ? defaultShadowDirection.x : 0);
        defaultShadowInsets.bottom = defaultShadowInsets.bottom + (defaultShadowDirection.y > 0 ? defaultShadowDirection.y : 0);
        defaultShadowInsets.right = defaultShadowInsets.right + (defaultShadowDirection.x > 0 ? defaultShadowDirection.x : 0);
        JLFGRIconProvider defaultIconProvider = new JLFGRIconProvider();
        Font l_font = UIManager.getFont("MenuItem.font");
        int defaultSmallIconSize = l_font != null ? l_font.getSize() : 16;
        defaultIconProvider.setSmallIconPreferredSize(new Dimension(defaultSmallIconSize, defaultSmallIconSize));
        AbstractOffWhiteColorFactory.setFactory(new DefaultOffWhiteColorFactory(offWhiteColor));
        AbstractNoColorPaintFactory.setFactory(new DefaultNoColorPaintFactory(16, Color.white, AbstractOffWhiteColorFactory.createOffWhiteColor()));
        AbstractApplicationIconFactory.setFactory(new DefaultApplicationIconFactory(defaultIconProvider, defaultOutlineColor));
        AbstractDropShadowBorderFactory.setFactory(new DefaultDropShadowBorderFactory(defaultShadowDirection, 0.5f));
        AbstractComponentBorderFactory.setFactory(new DefaultComponentBorderFactory(AbstractDropShadowBorderFactory.getInstance(), this.defaultRoundSize, l_nativeLNF));
        AbstractColorWheelIconFactory.setFactory(new DefaultColorWheelIconFactory(defaultExtent * 2 / 3, defaultExtent * 2 / 3, RYBColors.PRIMARY_SECONDARY_COLORS, Color.darkGray, new BasicStroke(defaultGridlineWidth), null, 0.5f));
        AbstractColorSchemeIconFactory.setFactory(new DefaultColorSchemeIconFactory(defaultExtent, defaultExtent, Color.white.darker(), Color.white, Color.gray, new BasicStroke(1.5f, 1, 1)));
        AbstractColorSourceIconFactory.setFactory(new DefaultColorSourceIconFactory(defaultExtent, defaultExtent, Color.white.darker(), Color.white, Color.gray, new BasicStroke(1.5f, 1, 1)));
        AbstractColorWheelSkinFactory.setFactory(new DefaultColorWheelSkinFactory(new BasicStroke(defaultOutlineWidth, 1, 1), AbstractOffWhiteColorFactory.createOffWhiteColor()));
        PaletteLayoutProvider.setProvider(new BasicPaletteLayoutProvider(preferredColorCardSize, defaultShadowInsets, Math.round(defaultOutlineWidth / 2.0f)));
        UIManager.put("colorwheel_components.JxColorComponent.arcw", this.defaultRoundSize);
        UIManager.put("colorwheel_components.JxColorComponent.arch", this.defaultRoundSize);
        UIManager.put("colorwheel_components.JxColorComponent.shadow_direction", defaultShadowDirection);
        UIManager.put("colorwheel_components.JxColorComponent.shadow_opacity", Float.valueOf(0.5f));
        UIManager.put("colorwheel_components.JxColorComponent.color_card_size", preferredColorCardSize);
        UIManager.put("colorwheel_components.JxColorComponent.color_chip_size", defaultExtent);
        UIManager.put("colorwheel_components.ColorCard.font", defaultFont);
        UIManager.put("colorwheel_components.ColorCard.preferredSize", preferredColorCardSize);
        UIManager.put("colorwheel_components.ColorCard.background", defaultBackgroundColor);
        UIManager.put("colorwheel_components.ColorCard.foreground", defaultForegroundColor);
        UIManager.put("colorwheel_components.ColorCard.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.ColorCard.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.ColorCard.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.ColorCard.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.JxColorWheel.font", defaultFont);
        UIManager.put("colorwheel_components.JxColorWheel.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.JxColorWheel.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.JxColorWheel.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.JxColorWheel.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.JxColorWheel.select_icon", AbstractColorWheelIconFactory.createColorWheelIcon());
        UIManager.put("colorwheel_components.ColorPalette.font", defaultFont);
        UIManager.put("colorwheel_components.ColorPalette.select_icon", AbstractColorWheelIconFactory.createColorWheelIcon());
        UIManager.put("colorwheel_components.ColorPalette.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.ColorPalette.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.MatchColorTuner.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.MatchColorTuner.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.VariateColorTuner.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.VariateColorTuner.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.VariateColorTuner.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.VariateColorTuner.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.ContrastPattern.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.ContrastPattern.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.ContrastPattern.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.ContrastPattern.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.ColorPicker.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.ColorPicker.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.ColorPicker.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.ColorPicker.outline_width", new Float(defaultOutlineWidth));
        UIManager.put("colorwheel_components.GrayscaleColorTuner.font", defaultFont);
        UIManager.put("colorwheel_components.GrayscaleColorTuner.gridline_color", defaultGridlineColor);
        UIManager.put("colorwheel_components.GrayscaleColorTuner.gridline_width", new Float(defaultGridlineWidth));
        UIManager.put("colorwheel_components.GrayscaleColorTuner.outline_color", defaultOutlineColor);
        UIManager.put("colorwheel_components.GrayscaleColorTuner.outline_width", new Float(defaultOutlineWidth));
        LookAndFeelUIDefaults.defaults = this;
    }

    @Override
    public int getRoundSize() {
        return this.defaultRoundSize;
    }
}

