/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.renderer;

import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class TextStroke
implements Stroke {
    private static final float FLATNESS = 1.0f;
    private final String text;
    private final Font font;
    private boolean stretchToFit = false;
    private final int alignment;

    public TextStroke(String text, Font font, int alignment) {
        this.text = text;
        this.font = font;
        this.stretchToFit = false;
        this.alignment = alignment;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        float l_margin;
        GeneralPath l_stroke = new GeneralPath();
        PathIterator l_it = shape.getPathIterator(null, 1.0);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector l_glyphVector = this.font.createGlyphVector(frc, this.text);
        int l_length = l_glyphVector.getNumGlyphs();
        float[] l_points = new float[6];
        float l_moveX = 0.0f;
        float l_moveY = 0.0f;
        float l_lastX = 0.0f;
        float _lastY = 0.0f;
        float l_curX = 0.0f;
        float l_curY = 0.0f;
        int l_charIndex = 0;
        float l_next = 0.0f;
        float l_nextAdvance = 0.0f;
        AffineTransform l_tx = new AffineTransform();
        if (l_length == 0) {
            return l_stroke;
        }
        float l_pathLength = TextStroke.lengthOf(shape);
        float l_factor = this.stretchToFit ? l_pathLength / (float)l_glyphVector.getLogicalBounds().getWidth() : 1.0f;
        switch (this.alignment) {
            case 4: {
                l_margin = l_pathLength - (float)l_glyphVector.getLogicalBounds().getWidth();
                break;
            }
            case 0: {
                l_margin = (l_pathLength - (float)l_glyphVector.getLogicalBounds().getWidth()) / 2.0f;
                break;
            }
            default: {
                l_margin = 0.0f;
            }
        }
        while (l_charIndex < l_length && !l_it.isDone()) {
            int l_type = l_it.currentSegment(l_points);
            switch (l_type) {
                case 0: {
                    l_moveX = l_lastX = l_points[0];
                    l_moveY = _lastY = l_points[1];
                    l_stroke.moveTo(l_moveX, l_moveY);
                    l_nextAdvance = l_glyphVector.getGlyphMetrics(l_charIndex).getAdvance() * 0.5f;
                    l_next = l_nextAdvance + l_margin;
                    break;
                }
                case 4: {
                    l_points[0] = l_moveX;
                    l_points[1] = l_moveY;
                }
                case 1: {
                    l_curX = l_points[0];
                    l_curY = l_points[1];
                    float dx = l_curX - l_lastX;
                    float dy = l_curY - _lastY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    if (distance >= l_next) {
                        float r = 1.0f / distance;
                        float angle = (float)Math.atan2(dy, dx);
                        while (l_charIndex < l_length && distance >= l_next) {
                            Shape glyph = l_glyphVector.getGlyphOutline(l_charIndex);
                            Point2D pnt = l_glyphVector.getGlyphPosition(l_charIndex);
                            float px = (float)pnt.getX();
                            float py = (float)pnt.getY();
                            float x = l_lastX + l_next * dx * r;
                            float y = _lastY + l_next * dy * r;
                            float advance = l_nextAdvance;
                            l_nextAdvance = l_charIndex < l_length - 1 ? l_glyphVector.getGlyphMetrics(l_charIndex + 1).getAdvance() * 0.5f : 0.0f;
                            l_tx.setToTranslation(x, y);
                            l_tx.rotate(angle);
                            l_tx.translate(-px - advance, -py);
                            l_stroke.append(l_tx.createTransformedShape(glyph), false);
                            l_next += (advance + l_nextAdvance) * l_factor;
                            ++l_charIndex;
                        }
                    }
                    l_next -= distance;
                    l_lastX = l_curX;
                    _lastY = l_curY;
                }
            }
            l_it.next();
        }
        return l_stroke;
    }

    public static float lengthOf(Shape shape) {
        PathIterator it = shape.getPathIterator(null, 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        int type = 0;
        float total = 0.0f;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    float dx = thisX - lastX;
                    float dy = thisY - lastY;
                    total += (float)Math.sqrt(dx * dx + dy * dy);
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return total;
    }
}

