/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.renderer;

import com.valeras.color_chart.ColorChartEntry;
import com.valeras.colorwheel_harmony.ui.swing.components.JxSimpleColorCard;
import com.valeras.colorwheel_harmony.ui.swing.model.ColorChartEntryColorCardModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ColorChartEntryCellRenderer
implements ListCellRenderer {
    private final JxSimpleColorCard component = new JxSimpleColorCard();

    public ColorChartEntryCellRenderer() {
        this.component.setOpaque(true);
        this.component.setColorCardHeadingEnabled(false);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color l_foreground;
        Color l_background;
        ColorChartEntry l_entry = (ColorChartEntry)value;
        ColorChartEntryColorCardModel l_model = new ColorChartEntryColorCardModel(l_entry);
        this.component.setBorder(this.createBorder(list, isSelected));
        this.component.setModel(l_model);
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            l_background = Color.BLUE;
            l_foreground = Color.WHITE;
        } else if (isSelected) {
            l_background = Color.GRAY;
            l_foreground = Color.WHITE;
        } else {
            l_background = Color.WHITE;
            l_foreground = Color.BLACK;
        }
        this.component.setBackground(l_background);
        this.component.setForeground(l_foreground);
        return this.component;
    }

    private Border createBorder(JList list, boolean selected) {
        int OUTER_INSET = 5;
        Insets INNER_INSETS = new Insets(4, 4, 0, 4);
        Color l_color = list != null ? list.getBackground() : Color.white;
        CompoundBorder l_spacer = new CompoundBorder(BorderFactory.createLineBorder(l_color, 5), BorderFactory.createLineBorder(Color.gray));
        CompoundBorder l_border = new CompoundBorder(l_spacer, BorderFactory.createEmptyBorder(INNER_INSETS.top, INNER_INSETS.left, INNER_INSETS.bottom, INNER_INSETS.right));
        return l_border;
    }
}

