/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog;

import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.resources.HarmonyResources;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.AbstractOptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class OptionsGeneralPanel
extends AbstractOptionsPanel {
    private static final String STR_TITLE = "panel.options.general.title";
    private static final String STR_LANGUAGE = "panel.options.general.language.label";
    private static final String STR_LANGUAGE_AUTO = "panel.options.general.language.auto";
    private static final String STR_SELECT_SKIN = "panel.options.general.colorwheel_cover.label";
    private static final String STR_DARK_BACKGROUND = "panel.options.general.dark_background.label";
    private final JCheckBox chkDarkBackground = new JCheckBox(StringTable.get("panel.options.general.dark_background.label"));
    private final JLabel lblCover;
    private final JLabel lblLanguage;
    private final JComboBox cmbCover;
    private final JComboBox cmbLanguage;
    private final ArrayList<String> coverList;
    private final ArrayList<LocaleWrapper> localeList;

    public OptionsGeneralPanel(ApplicationSettings settings) {
        super(StringTable.get(STR_TITLE), settings);
        this.chkDarkBackground.setOpaque(false);
        this.lblLanguage = new JLabel(StringTable.get(STR_LANGUAGE));
        this.cmbLanguage = new JComboBox();
        this.lblCover = new JLabel(StringTable.get(STR_SELECT_SKIN));
        this.cmbCover = new JComboBox();
        this.coverList = new ArrayList();
        DefaultComboBoxModel<Object> l_model = new DefaultComboBoxModel<Object>();
        this.coverList.add("colorwheel_skin.off_white");
        this.coverList.add("colorwheel_skin.white_matte");
        this.coverList.add("colorwheel_skin.smoked_glass");
        for (int i = 0; i < this.coverList.size(); ++i) {
            l_model.addElement(StringTable.get(this.coverList.get(i)));
        }
        this.cmbCover.setModel(l_model);
        this.localeList = new ArrayList();
        l_model = new DefaultComboBoxModel();
        List<Locale> l_locales = HarmonyResources.getSupportedLocales();
        Locale l_current = settings.getLanguage();
        this.localeList.add(new LocaleWrapper(null));
        for (int i = 0; i < l_locales.size(); ++i) {
            this.localeList.add(new LocaleWrapper(l_locales.get(i)));
        }
        for (LocaleWrapper l : this.localeList) {
            l_model.addElement(l);
            if (l_current == null) {
                if (l.getLocale() != null) continue;
                l_model.setSelectedItem(l);
                continue;
            }
            if (!l_current.equals(l.getLocale())) continue;
            l_model.setSelectedItem(l);
        }
        this.cmbLanguage.setModel(l_model);
        this.cmbLanguage.setPreferredSize(new Dimension(this.cmbCover.getPreferredSize().width * 3 / 2, this.cmbLanguage.getPreferredSize().height));
        this.chkDarkBackground.setSelected(settings.getDarkBackgroundEnabled());
        this.cmbCover.setSelectedIndex(this.coverList.indexOf(settings.getColorWheelCover()));
        this.add((Component)this.lblLanguage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.cmbLanguage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.lblCover, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.cmbCover, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, this.optionInsets, 0, 0));
        this.add((Component)this.chkDarkBackground, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
    }

    @Override
    public void applySettings() {
        this.settings.setDarkBackgroundEnabled(this.chkDarkBackground.isSelected());
        this.settings.setColorWheelCover(this.coverList.get(this.cmbCover.getSelectedIndex()));
        this.settings.setLanguage(this.localeList.get(this.cmbLanguage.getSelectedIndex()).getLocale());
    }

    private static class LocaleWrapper {
        private static final String STR_TOSTRING = "{0} ({1})";
        private final Locale locale;

        public LocaleWrapper(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            String l_text = this.locale != null ? MessageFormat.format(STR_TOSTRING, this.locale.getDisplayLanguage(), this.locale.getDisplayCountry()) : StringTable.get(OptionsGeneralPanel.STR_LANGUAGE_AUTO);
            return l_text;
        }
    }
}

