/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog;

import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.model.ColorSpaceProvider;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.AbstractOptionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class OptionsAdvancedPanel
extends AbstractOptionsPanel {
    private static final String STR_TITLE = "panel.options.advanced.title";
    private static final String STR_DEFAULT_LNF = "panel.options.advanced.default_lnf.label";
    private static final String STR_LARGE_COLOR_CARDS = "panel.options.general.large_color_cards.label";
    private static final String STR_SCREEN_CAPTURE_DELAY = "panel.options.advanced.screen_capture_delay.label";
    private static final String STR_CMYK_PROFILE = "panel.options.cmyk_profile.label";
    private final JCheckBox chkDefaultLNF = new JCheckBox(StringTable.get("panel.options.advanced.default_lnf.label"));
    private final JCheckBox ckbLargeColorCards;
    private final JCheckBox ckbScreenCaptureDelay;
    private final JLabel lblCMYKProfile;
    private final JComboBox cmbCMYKProfile;

    public OptionsAdvancedPanel(final ApplicationSettings settings) {
        super(StringTable.get(STR_TITLE), settings);
        this.chkDefaultLNF.setOpaque(false);
        this.chkDefaultLNF.setSelected(settings.getDefaultLNFEnabled());
        this.ckbLargeColorCards = new JCheckBox(StringTable.get(STR_LARGE_COLOR_CARDS));
        this.ckbLargeColorCards.setOpaque(false);
        this.ckbLargeColorCards.setSelected(settings.getLargeColorCards());
        this.ckbScreenCaptureDelay = new JCheckBox(StringTable.get(STR_SCREEN_CAPTURE_DELAY));
        this.ckbScreenCaptureDelay.setOpaque(false);
        this.ckbScreenCaptureDelay.setSelected(settings.getScreenCaptureDelayEnabled());
        this.lblCMYKProfile = new JLabel(StringTable.get(STR_CMYK_PROFILE));
        this.cmbCMYKProfile = new JComboBox();
        DefaultComboBoxModel<ProfileParams> l_model = new DefaultComboBoxModel<ProfileParams>();
        ColorSpaceProvider l_csp = ColorSpaceProvider.getInstance();
        List<String> l_profiles = l_csp.listCMYKProfiles();
        String l_currentProfileName = settings.getCMYKProfile();
        ProfileParams l_selectedProfile = null;
        for (String pn : l_profiles) {
            ProfileParams l_profile = new ProfileParams(pn, l_csp.getProfileName(pn));
            l_model.addElement(l_profile);
            if (!l_currentProfileName.equals(l_profile.getName())) continue;
            l_selectedProfile = l_profile;
        }
        l_model.setSelectedItem(l_selectedProfile);
        this.cmbCMYKProfile.setModel(l_model);
        this.cmbCMYKProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileParams l_profile = (ProfileParams)OptionsAdvancedPanel.this.cmbCMYKProfile.getSelectedItem();
                settings.setCMYKProfile(l_profile.getName());
            }
        });
        this.add((Component)this.chkDefaultLNF, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.ckbLargeColorCards, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.ckbScreenCaptureDelay, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.lblCMYKProfile, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
        this.add((Component)this.cmbCMYKProfile, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, this.optionInsets, 0, 0));
    }

    @Override
    public void applySettings() {
        this.settings.setDefaultLNFEnabled(this.chkDefaultLNF.isSelected());
        this.settings.setLargeColorCards(this.ckbLargeColorCards.isSelected());
        this.settings.setScreenCaptureDelayEnabled(this.ckbScreenCaptureDelay.isSelected());
    }

    private static class ProfileParams {
        private final String name;
        private final String displayName;

        public ProfileParams(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

