/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.TexturePaint;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SeamlessTexturePanel
extends JPanel {
    private static final String STR_ORIGINAL_TILING = "dialog.seamless_texture.original_tiling.caption";
    private static final String STR_SEAMLESS_TILING = "dialog.seamless_texture.seamless_tiling.caption";
    private final TilingPanel originalImagePane;
    private final TilingPanel seamlessImagePane;
    private final JPanel previewPanel;

    public SeamlessTexturePanel(TexturePaint originalTiling, TexturePaint seamlessTiling) {
        this.setLayout(new BorderLayout());
        Dimension l_panelSize = new Dimension(320, 320);
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new BoxLayout(this.previewPanel, 0));
        this.originalImagePane = new TilingPanel(originalTiling);
        this.originalImagePane.setBorder(this.createPaneBorder(StringTable.get(STR_ORIGINAL_TILING)));
        this.originalImagePane.setPreferredSize(l_panelSize);
        this.seamlessImagePane = new TilingPanel(seamlessTiling);
        this.seamlessImagePane.setBorder(this.createPaneBorder(StringTable.get(STR_SEAMLESS_TILING)));
        this.seamlessImagePane.setPreferredSize(l_panelSize);
        this.previewPanel.add(this.originalImagePane);
        this.previewPanel.add(Box.createHorizontalStrut(8));
        this.previewPanel.add(this.seamlessImagePane);
        this.add((Component)this.previewPanel, "Center");
    }

    private Border createPaneBorder(String title) {
        return AbstractComponentBorderFactory.createComponentBorder(title, false);
    }

    private class TilingPanel
    extends JPanel {
        private Paint paint;

        public TilingPanel(Paint paint) {
            this.paint = paint;
        }

        public void setTiling(Paint paint) {
            this.paint = paint;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D l_gr = (Graphics2D)g.create();
            Insets l_insets = this.getInsets();
            super.paintComponent(g);
            if (this.paint != null) {
                l_gr.setPaint(this.paint);
                l_gr.fillRect(l_insets.left, l_insets.top, this.getWidth() - (l_insets.left + l_insets.right), this.getHeight() - (l_insets.top + l_insets.bottom));
            }
            l_gr.dispose();
        }
    }
}

