/*
 * Decompiled with CFR 0.152.
 */
package com.valeras.colorwheel_harmony.ui.swing.panels;

import com.valeras.colorwheel_harmony.app_core.ApplicationSettings;
import com.valeras.colorwheel_harmony.app_core.StringTable;
import com.valeras.colorwheel_harmony.ui.swing.AbstractComponentBorderFactory;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.AbstractOptionsPanel;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.OptionsAdvancedPanel;
import com.valeras.colorwheel_harmony.ui.swing.panels.options_dialog.OptionsGeneralPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class OptionsPanel
extends JPanel {
    private static final String STR_CATEGORY = "dialog.options.panel.category.title";
    private static final String STR_OPTIONS = "dialog.options.panel.options.title";
    private final ArrayList<AbstractOptionsPanel> panels;
    private final ArrayList<AbstractButton> buttons;
    private final ButtonGroup buttonGroup;
    private final JPanel buttonPane;
    private final JPanel optionsPane;
    private final JPanel categoryPanel;
    private final JScrollPane contentPanel;
    private int selectedCategoryIndex;

    public OptionsPanel(ApplicationSettings settings) {
        this.setLayout(new BorderLayout());
        this.panels = new ArrayList();
        this.buttons = new ArrayList();
        this.buttonGroup = new ButtonGroup();
        this.categoryPanel = new JPanel();
        this.categoryPanel.setLayout(new BorderLayout());
        this.categoryPanel.setBorder(this.createPaneBorder(StringTable.get(STR_CATEGORY)));
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridBagLayout());
        this.categoryPanel.add((Component)this.buttonPane, "North");
        this.contentPanel = new JScrollPane();
        this.contentPanel.setBorder(this.createPaneBorder(StringTable.get(STR_OPTIONS)));
        this.contentPanel.setPreferredSize(new Dimension(400, 300));
        this.contentPanel.setBackground(this.buttonPane.getBackground());
        this.optionsPane = new JPanel();
        this.optionsPane.setLayout(new FlowLayout(0));
        this.createCategory(new OptionsGeneralPanel(settings));
        this.createCategory(new OptionsAdvancedPanel(settings));
        this.add((Component)this.categoryPanel, "West");
        this.add((Component)this.contentPanel, "Center");
        this.setSelectedCategory(0, true);
    }

    public void applySettings() {
        for (AbstractOptionsPanel p : this.panels) {
            p.applySettings();
        }
    }

    private AbstractButton createCategory(AbstractOptionsPanel panel) {
        Insets l_buttonInsets = new Insets(5, 5, 0, 5);
        this.panels.add(panel);
        AbstractButton l_button = this.createCategoryButton(panel);
        this.buttons.add(l_button);
        this.buttonGroup.add(l_button);
        this.buttonPane.add((Component)l_button, new GridBagConstraints(0, this.buttons.indexOf(l_button), 2, 1, 0.0, 0.0, 17, 2, l_buttonInsets, 0, 0));
        return l_button;
    }

    private Border createPaneBorder(String title) {
        return AbstractComponentBorderFactory.createComponentBorder(title, false);
    }

    protected int getSelectedCategoryIndex() {
        return this.selectedCategoryIndex;
    }

    private void setSelectedCategory(int index, boolean selectButton) {
        AbstractButton l_button = this.buttons.get(index);
        if (selectButton) {
            this.buttonGroup.setSelected(l_button.getModel(), true);
        }
        AbstractOptionsPanel l_panel = this.panels.get(index);
        this.optionsPane.removeAll();
        this.optionsPane.add(l_panel);
        this.contentPanel.setViewportView(this.optionsPane);
        this.selectedCategoryIndex = index;
    }

    private AbstractButton createCategoryButton(AbstractOptionsPanel panel) {
        JToggleButton l_button = new JToggleButton(panel.getName());
        l_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int l_index = OptionsPanel.this.buttons.indexOf(e.getSource());
                OptionsPanel.this.setSelectedCategory(l_index, false);
            }
        });
        return l_button;
    }
}

